package de.pfabulist.kleinod.nio;

import de.pfabulist.frex.Frex;

import java.util.Optional;
import java.util.regex.Pattern;

import static de.pfabulist.roast.lang.Strings_.getBytes;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class PathSpecUnix implements PathSpec {
    private static final Pattern separatorPat = Frex.txt( '/' ).buildPattern();

    @Override
    public int getMaxPathLength() {
        return 4095; // linux max path - null terminator
    }

    @Override
    public int getPathLength( String str ) {
        return getBytes( str ).length;
    }

    @Override
    public int getMaxFilenameLength() {
        return 255;
    }

    @Override
    public int getFilenameLength( String str ) {
        return getBytes( str ).length;
    }

    @Override
    public RC getRootComponent( String str ) {
        return new RC( Optional.empty(), str );
    }

    @Override
    public String getNormalForm( String str ) {
        return str;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Pattern getAllSeparators() {
        return separatorPat;
    }
}
