/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BigIO {
    private final long upto;
    private final InputStream is = new InputStream(){
        private long count = 0L;

        @Override
        public int read() throws IOException {
            if (this.count >= BigIO.this.upto) {
                return -1;
            }
            ++this.count;
            return BigIO.this.extract0To255(this.count);
        }
    };
    private final BigOutputStream os = new BigOutputStream(){
        private long count = 0L;

        @Override
        long getCount() {
            return this.count;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count >= BigIO.this.upto) {
                throw new IOException("more bytes than expected (>=" + BigIO.this.upto);
            }
            ++this.count;
            int val = BigIO.this.getLower8Bit(b);
            int expected = BigIO.this.extract0To255(this.count);
            if (expected != val) {
                throw new IOException("unexpected value. expected " + expected + " got " + val + " at position " + this.count);
            }
        }
    };

    public BigIO(long upto) {
        this.upto = upto;
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public boolean consumed() {
        return this.os.getCount() >= this.upto;
    }

    private int getLower8Bit(int b) {
        return b >= 0 ? b : b + 256;
    }

    private int extract0To255(long count) {
        return (int)(count & 0xFFL);
    }

    private static abstract class BigOutputStream
    extends OutputStream {
        private BigOutputStream() {
        }

        abstract long getCount();
    }
}

