package de.pfabulist.kleinod.nio;

import java.nio.file.attribute.FileTime;
import java.util.Comparator;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class FileTimeComparator {

    private FileTimeComparator() {}

    public static int roughlyComparableTo( FileTime a, FileTime b ) {
        long diff = a.toMillis() - b.toMillis();

        if ( -500 <= diff && diff <= 500 ) {
            return 0;
        }

        return diff < 0 ? -1 : 1;
    }

    public static Comparator<FileTime> isWithIn( long millis ) {
        return (x,y) -> {
            long diff = x.toMillis() - y.toMillis();

            if ( -millis <= diff && diff <= millis ) {
                return 0;
            }

            return diff < 0 ? -1 : 1;
        };
    }
}
