package de.pfabulist.kleinod.nio;

import de.pfabulist.frex.Frex;

import java.util.Optional;
import java.util.regex.Pattern;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class PathSpecDefault implements PathSpec {
    @Override
    public int getMaxPathLength() {
        return 1000;
    }

    @Override
    public int getPathLength( String str ) {
        return PathSpec.getBytes( str ).length;
    }

    @Override
    public int getMaxFilenameLength() {
        return 255;
    }

    @Override
    public int getFilenameLength( String str ) {
        return PathSpec.getBytes( str ).length;
    }

    @Override
    public int compareTo( String a, String b ) {
        return a.compareTo( b );
    }

    @Override
    public RC getRootComponent( String str ) {
        return new RC( Optional.empty(), str );
    }

    @Override
    public String getNormalForm( String str ) {
        return str;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Pattern getAllSeparators() {
        return Frex.txt('/').or( Frex.txt('\\') ).buildPattern();
    }
}
