package de.pfabulist.kleinod.nio;

import de.pfabulist.roast.collection.Listt;

import java.util.ArrayList;
import java.util.Collections;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */
public final class Relativize {

    private Relativize() {
    }

    public static <T> int findCommonSuffix( Listt<T> one, Listt<T> two ) {
        int i = 0;
        for( ; i < one.size() && i < two.size(); i++ ) {
            if( !one.get( i ).equals( two.get( i ) ) ) {
                return i;
            }
        }

        return i;
    }

    public static Listt<String> relativize( Listt<String> from, Listt<String> to ) {

        if( from.equals( Listt.of( Collections.singletonList( "" )) ) ) {
            return to;
        }

        Listt<String> ret = Listt.of( new ArrayList<>());

        int suf = findCommonSuffix( from, to );

        int i;
        for( i = 0; i < from.size() - suf; i++ ) {
            ret.add( ".." );
        }

        for( i = suf; i < to.size(); i++ ) {
            ret.add( to.get( i ) );
        }

        if( ret.isEmpty() ) {
            return Listt.of( Collections.singletonList( "" ));
        }

        return ret;
    }
}
