package de.pfabulist.kleinod.nio;

import de.pfabulist.roast.nio.Filess;
import de.pfabulist.roast.nio.Pathh;

import javax.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import static de.pfabulist.roast.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class UnzipToPath {

    private UnzipToPath() {}

    public static void unzipToPath( InputStream is, Pathh root ) {
        try( ZipInputStream zin = new ZipInputStream( is ) ) {

            @Nullable ZipEntry ze;
            while( ( ze = zin.getNextEntry() ) != null ) {
                String name   = ze.getName();
                Pathh  target = root.resolve( name );

                if( name.endsWith( "/" ) ) {
                    Filess.createDirectories( target );
                } else {
                    Filess.copy( zin, target );
                }
                zin.closeEntry();
            }
        } catch( IOException e ) {
            throw u( e );
        }

    }

}
