/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.encode;

import de.pfabulist.roast.NonnullCheck;
import java.util.HashMap;
import java.util.Map;

public final class Base16 {
    private static final Map<String, Byte> toNum = new HashMap<String, Byte>();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Base16() {
    }

    public static String encode(byte[] src) {
        char[] buf = new char[src.length * 2];
        int x = 0;
        for (int i = 0; i < src.length; ++i) {
            buf[x++] = HEX_CHARS[src[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[src[i] & 0xF];
        }
        return new String(buf);
    }

    public static byte[] decode(String src) {
        if (src.length() / 2 * 2 < src.length()) {
            throw new IllegalArgumentException("string's length is odd " + src);
        }
        byte[] ret = new byte[src.length() / 2];
        for (int i = 0; i < src.length(); i += 2) {
            String substring = src.substring(i, i + 2);
            if (!toNum.containsKey(substring)) {
                throw new IllegalArgumentException("not a base16 encoded string: " + src);
            }
            ret[i / 2] = (Byte)NonnullCheck._nn((Object)toNum.get(substring));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<String, Byte> map = toNum;
        synchronized (map) {
            byte[] by = new byte[1];
            for (int b = -128; b <= 127; ++b) {
                by[0] = (byte)b;
                toNum.put(Base16.encode(by), by[0]);
            }
        }
    }
}

