/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.nio;

import de.pfabulist.kleinod.os.OS;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class PathLimits {
    private final OS os;
    private static final String one4ByteUnicode = new String(Character.toChars(66560));
    private static final String one2ByteUnicode = "\uaaaa";
    private static final String oneOSXCount = "\uaaaa";
    private static final String oneWindowsCount = "\uaaaa";
    private static final String oneUnixCount = "a";

    public PathLimits(OS os) {
        this.os = os;
    }

    public int getMaxFilenameLength() {
        return 255;
    }

    public int filenameCount(String fname) {
        if (this.os.isOSX()) {
            return fname.length();
        }
        if (this.os.isUnix()) {
            return PathLimits.getBytes(fname).length;
        }
        if (this.os.isWindows()) {
            return fname.codePointCount(0, fname.length());
        }
        throw new UnsupportedOperationException("unsupported os " + this.os);
    }

    public String getBigChar() {
        if (this.os.isOSX()) {
            return "\uaaaa";
        }
        if (this.os.isWindows()) {
            return "\uaaaa";
        }
        return oneUnixCount;
    }

    public int getMaxPathLength() {
        if (this.os.isWindows()) {
            return 32000;
        }
        if (this.os.isOSX()) {
            return 1016;
        }
        if (this.os.isUnix()) {
            return 4095;
        }
        throw new UnsupportedOperationException("os not supported: " + this.os);
    }

    public boolean bigUnicodeCountsAs1() {
        return this.os.isWindows();
    }

    static byte[] getBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public int compareTo(String a, String b) {
        if (this.os.isOSX() || this.os.isWindows()) {
            return a.toLowerCase(Locale.getDefault()).compareTo(b.toLowerCase(Locale.getDefault()));
        }
        if (this.os.isUnix()) {
            return a.compareTo(b);
        }
        throw new UnsupportedOperationException("os not supported: " + this.os);
    }

    public int hash(String str) {
        if (this.os.isOSX() || this.os.isWindows()) {
            return str.toLowerCase(Locale.getDefault()).hashCode();
        }
        if (this.os.isUnix()) {
            return str.hashCode();
        }
        throw new UnsupportedOperationException("os not supported: " + this.os);
    }

    public static enum CharType {
        UTF8,
        UNICODE1,
        FULL_UNICODE;

    }
}

