/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.nio;

import de.pfabulist.kleinod.nio.PathSpecDefault;
import de.pfabulist.kleinod.nio.PathSpecOSX;
import de.pfabulist.kleinod.nio.PathSpecUnix;
import de.pfabulist.kleinod.nio.PathSpecWindows;
import de.pfabulist.kleinod.os.OS;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Pattern;

public interface PathSpec {
    public int getMaxPathLength();

    public int getPathLength(String var1);

    public int getMaxFilenameLength();

    public int getFilenameLength(String var1);

    public int compareTo(String var1, String var2);

    public RC getRootComponent(String var1);

    public String getNormalForm(String var1);

    public String getSeparator();

    public Pattern getAllSeparators();

    default public Optional<Pattern> getIllegalCharacters() {
        return Optional.empty();
    }

    default public Optional<String> filenameIsNotValidBecause(String str) {
        return this.getIllegalCharacters().filter(pat -> pat.matcher(str).matches()).map(p -> "contains an illegal character " + str);
    }

    public static byte[] getBytes(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static PathSpec byOS(OS os) {
        if (os.isWindows()) {
            return new PathSpecWindows();
        }
        if (os.isOSX()) {
            return new PathSpecOSX();
        }
        if (os.isUnix()) {
            return new PathSpecUnix();
        }
        return new PathSpecDefault();
    }

    public static class RC {
        public final Optional<String> root;
        public final String path;

        public RC(Optional<String> root, String path) {
            this.root = root;
            this.path = path;
        }
    }
}

