/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.nio;

import de.pfabulist.frex.CharacterClass;
import de.pfabulist.frex.Frex;
import de.pfabulist.kleinod.nio.PathSpec;
import java.nio.file.InvalidPathException;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathSpecWindows
implements PathSpec {
    private static final String UNCPATH = "uncpath";
    private static final String UNCSERVER = "uncserver";
    private static final String UNCSHARE = "uncShare";
    private final Pattern drives = Frex.startsWith((Frex)Frex.alpha().andThen(Frex.txt((String)":"))).buildPattern();
    private final CharacterClass slash = Frex.txt((char)'\\').or((CharacterClass)Frex.txt((char)'/'));
    private final Pattern unc = this.slash.atLeast(2).andThen(Frex.anyBut((CharacterClass)this.slash).oneOrMore().group("uncserver")).andThen((Frex)this.slash.atLeast(1)).andThen(Frex.anyBut((CharacterClass)this.slash).oneOrMore().group("uncShare")).andThen(this.slash.andThen((Frex)Frex.any().zeroOrMore()).zeroOrOnce().group("uncpath")).buildPattern();
    private final Pattern doubleSlashStart = Frex.startsWith((Frex)this.slash.times(2)).buildPattern();
    private static final Pattern separatorPat = Frex.or((Frex[])new Frex[]{Frex.txt((char)'\\'), Frex.txt((char)'/')}).buildPattern();

    @Override
    public int getMaxPathLength() {
        return 32000;
    }

    @Override
    public int getPathLength(String str) {
        return str.length();
    }

    @Override
    public int getMaxFilenameLength() {
        return 255;
    }

    @Override
    public int getFilenameLength(String str) {
        return str.codePointCount(0, str.length());
    }

    @Override
    public int compareTo(String a, String b) {
        return this.getNormalForm(a).compareTo(this.getNormalForm(b));
    }

    @Override
    public PathSpec.RC getRootComponent(String str) {
        if (this.drives.matcher(str).matches()) {
            return new PathSpec.RC(Optional.of(this.getNormalForm(str.substring(0, 2))), str.substring(2));
        }
        if (!this.doubleSlashStart.matcher(str).matches()) {
            return new PathSpec.RC(Optional.empty(), str);
        }
        Matcher matcher = this.unc.matcher(str);
        if (!matcher.matches()) {
            throw new InvalidPathException(str, "illegal path (not unc)");
        }
        String path = Optional.ofNullable(matcher.group(UNCPATH)).orElseThrow(() -> new IllegalStateException("bad group name"));
        String server = this.getNormalForm(Optional.ofNullable(matcher.group(UNCSERVER)).orElseThrow(() -> new IllegalStateException("bad group name")));
        String share = this.getNormalForm(Optional.ofNullable(matcher.group(UNCSHARE)).orElseThrow(() -> new IllegalStateException("bad group name")));
        return new PathSpec.RC(Optional.of("\\\\" + server + "\\" + share), path.isEmpty() ? "\\" : path);
    }

    @Override
    public String getNormalForm(String str) {
        return str.toLowerCase(Locale.getDefault()).replace('/', '\\');
    }

    @Override
    public String getSeparator() {
        return "\\";
    }

    @Override
    public Pattern getAllSeparators() {
        return separatorPat;
    }

    @Override
    public Optional<Pattern> getIllegalCharacters() {
        return Optional.of(Frex.contains((Frex)Frex.or((Frex[])new Frex[]{Frex.txt((char)':'), Frex.txt((char)'?'), Frex.txt((char)'<'), Frex.txt((char)'>'), Frex.txt((char)'*'), Frex.txt((char)'|'), Frex.txt((char)'\"')})).buildPattern());
    }
}

