package de.pfabulist.kleinod.collection;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class Sets {

    private Sets() {}

    @SafeVarargs
    public static <T> Set<T> asSet( T ... elems ) {
        Set<T> ret = new HashSet<>();

        ret.addAll( Arrays.asList(elems ));

        return ret;
    }

}
