package de.pfabulist.kleinod.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class Net {

    private Net() {}

    public static boolean isOnline() { //String addr, int openPort, int timeOutMillis) {
        return isReachable( "www.google.com", 80, 1000 );
    }

    public static boolean isReachable( String addr, int openPort, int timeOutMillis) {
        // Any Open port on other machine
        // openPort =  22 - ssh, 80 or 443 - webserver, 25 - mailserver etc.
        try {
            try( Socket soc = new Socket() ) {
                soc.connect( new InetSocketAddress( addr, openPort ), timeOutMillis );
            }
            return true;
        } catch( IOException ex ) {
            return false;
        }

    }
}
