/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.nio;

import java.nio.file.attribute.FileTime;
import java.util.Comparator;

public final class FileTimeComparator {
    private FileTimeComparator() {
    }

    public static int roughlyComparableTo(FileTime a, FileTime b) {
        long diff = a.toMillis() - b.toMillis();
        if (-500L <= diff && diff <= 500L) {
            return 0;
        }
        return diff < 0L ? -1 : 1;
    }

    public static Comparator<FileTime> isWithIn(long millis) {
        return (x, y) -> {
            long diff = x.toMillis() - y.toMillis();
            if (-millis <= diff && diff <= millis) {
                return 0;
            }
            return diff < 0L ? -1 : 1;
        };
    }
}

