/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.nio;

import de.pfabulist.roast.NonnullCheck;
import de.pfabulist.roast.nio.Files_;
import de.pfabulist.roast.unchecked.Unchecked;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class UnzipToPath {
    private UnzipToPath() {
    }

    public static void unzipToPath(InputStream is, Path root) {
        try (ZipInputStream zin = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                String name = ze.getName();
                Path target = (Path)NonnullCheck.n_((Object)root.resolve(name));
                if (name.endsWith("/")) {
                    Files_.createDirectories((Path)target, (FileAttribute[])new FileAttribute[0]);
                } else {
                    Files_.copy((InputStream)zin, (Path)target, (CopyOption[])new CopyOption[0]);
                }
                zin.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("UnzipToPath " + e.getMessage());
            throw Unchecked.e_((Throwable)e);
        }
    }
}

