package de.pfabilist.kleinod.log;

/**
 * ** BEGIN LICENSE BLOCK *****
 * BSD License (2 clause)
 * Copyright (c) 2006 - 2015, Stephan Pfab
 * All rights reserved.
 * <p>
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * <p>
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL Stephan Pfab BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * **** END LICENSE BLOCK ****
 */

import com.esotericsoftware.minlog.Log;

/**
 * Performs the actual logging. Default implementation logs to slf4j. Extended and use {@link Log#logger} set to handle
 * logging differently.
 */
public class MinlogToSLF4J extends Log.Logger {

    static {
        Log.setLogger( new MinlogToSLF4J() );
    }

    // Log as "com.esotericsoftware.minlog"
    private final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger( MinlogToSLF4J.class.getPackage().getName() );

    public void log( int level, String category, String message, Throwable ex ) {
        StringBuilder builder = new StringBuilder( 256 );
        if( category != null ) {
            builder.append( category );
            builder.append( ": " );
        }
        builder.append( message );
        String line = builder.toString();

        switch( level ) {
            case Log.LEVEL_ERROR:
                logger.error( line, ex );
                break;
            case Log.LEVEL_WARN:
                logger.warn( line, ex );
                break;
            case Log.LEVEL_INFO:
                logger.info( line, ex );
                break;
            case Log.LEVEL_DEBUG:
                logger.debug( line, ex );
                break;
            case Log.LEVEL_TRACE:
                logger.trace( line, ex );
                break;
            default:
                logger.error( line, ex );
                break;
        }
    }
}
