/*
 * Decompiled with CFR 0.152.
 */
package de.pfabilist.kleinod.log;

import com.esotericsoftware.minlog.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinlogToSLF4J
extends Log.Logger {
    private final Logger logger = LoggerFactory.getLogger((String)MinlogToSLF4J.class.getPackage().getName());

    public void log(int level, String category, String message, Throwable ex) {
        StringBuilder builder = new StringBuilder(256);
        if (category != null) {
            builder.append(category);
            builder.append(": ");
        }
        builder.append(message);
        String line = builder.toString();
        switch (level) {
            case 5: {
                this.logger.error(line, ex);
                break;
            }
            case 4: {
                this.logger.warn(line, ex);
                break;
            }
            case 3: {
                this.logger.info(line, ex);
                break;
            }
            case 2: {
                this.logger.debug(line, ex);
                break;
            }
            case 1: {
                this.logger.trace(line, ex);
                break;
            }
            default: {
                this.logger.error(line, ex);
            }
        }
    }

    static {
        Log.setLogger((Log.Logger)new MinlogToSLF4J());
    }
}

