package de.pfabulist.kleinod.crypt;

import com.esotericsoftware.minlog.Log;

import javax.crypto.Cipher;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

// todo does this class really do anything usefull ?
public final class KeySize {

    private KeySize() {}

    public static int get( String cipher ) {
        try {
            return Math.min( 256, Cipher.getMaxAllowedKeyLength( cipher ) );
        } catch( NoSuchAlgorithmException e ) {
            Log.warn( "unlimited strength libs missing from java, key is only 128 bits" );
            return 128;
        }
    }
}
