package de.pfabulist.kleinod.nio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static de.pfabulist.roast.types.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */
public final class Relativize {

    private Relativize() {
    }

    public static <T> int findCommonSuffix( List<T> one, List<T> two ) {
        int i = 0;
        for( ; i < one.size() && i < two.size(); i++ ) {
            if( !n_(one.get( i )).equals( two.get( i ) ) ) {
                return i;
            }
        }

        return i;
    }

    public static List<String> relativize( List<String> from, List<String> to ) {

        if( from.equals( Collections.singletonList( "" )) )  {
            return to;
        }

        List<String> ret = new ArrayList<>();

        int suf = findCommonSuffix( from, to );

        int i;
        for( i = 0; i < from.size() - suf; i++ ) {
            ret.add( ".." );
        }

        for( i = suf; i < to.size(); i++ ) {
            ret.add( to.get( i ) );
        }

        if( ret.isEmpty() ) {
            return Collections.singletonList( "" );
        }

        return ret;
    }
}
