package de.pfabulist.kleinod.nio;

import de.pfabulist.roast.nio.Files_;

import javax.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

import static de.pfabulist.roast.types.NonnullCheck.n_;
import static de.pfabulist.roast.unchecked.Unchecked.e_;
import static de.pfabulist.roast.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class UnzipToPath {

    private UnzipToPath() {}

    public static void unzipToPath( InputStream is, Path root ) {

        try( ZipInputStream zin = new ZipInputStream( is ) ) {

            @Nullable ZipEntry ze;
            while( ( ze = zin.getNextEntry() ) != null ) {

                String name   = ze.getName();

                Path  target = n_( root.resolve( name ));

                if( name.endsWith( "/" ) ) {
                    Files_.createDirectories( target );
                } else {
                    Files_.copy( zin, target );
                }
                zin.closeEntry();
            }
        } catch( IOException e ) {
            e.printStackTrace();
            System.out.println( "UnzipToPath " + e.getMessage() );
            throw e_( e );
        }

    }

}
