/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.nio;

import de.pfabulist.roast.types.NonnullCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Relativize {
    private Relativize() {
    }

    public static <T> int findCommonSuffix(List<T> one, List<T> two) {
        int i;
        for (i = 0; i < one.size() && i < two.size(); ++i) {
            if (NonnullCheck.n_(one.get(i)).equals(two.get(i))) continue;
            return i;
        }
        return i;
    }

    public static List<String> relativize(List<String> from, List<String> to) {
        int i;
        if (from.equals(Collections.singletonList(""))) {
            return to;
        }
        ArrayList<String> ret = new ArrayList<String>();
        int suf = Relativize.findCommonSuffix(from, to);
        for (i = 0; i < from.size() - suf; ++i) {
            ret.add("..");
        }
        for (i = suf; i < to.size(); ++i) {
            ret.add(to.get(i));
        }
        if (ret.isEmpty()) {
            return Collections.singletonList("");
        }
        return ret;
    }
}

