/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.os;

import de.pfabulist.frex.Frex;
import de.pfabulist.frex.Patternn;
import de.pfabulist.roast.NonnullCheck;

public class OS {
    public static final OS UNIX = new OS("unix");
    public static final OS WINDOWS = new OS("windows");
    public static final OS OSX = new OS("Mac OS X");
    private static final Patternn UNIX_PATTERN = Frex.or((Frex[])new Frex[]{Frex.txt((String)"Linux"), Frex.txt((String)"Solaris"), Frex.txt((String)"SunOS"), Frex.txt((String)"HP-UX"), Frex.txt((String)"AIX"), Frex.txt((String)"FreeBSD"), Frex.txt((String)"Irix"), Frex.txt((String)"Digital Unix"), Frex.txt((String)"OSF1"), Frex.startsWith((String)"Mac OS X"), Frex.contains((String)"BSD"), Frex.contains((String)"nix"), Frex.contains((String)"nux")}).buildCaseInsensitivePatternn();
    private static final Patternn WINDOWS_PATTERN = Frex.startsWith((String)"windows").buildCaseInsensitivePatternn();
    private static final Patternn OSX_PATTERN = Frex.startsWith((String)"mac os x").buildCaseInsensitivePatternn();
    private static final Patternn LINUX_PATTERN = Frex.contains((String)"linux").buildCaseInsensitivePatternn();
    private final String osName;

    public OS() {
        this((String)NonnullCheck._nn((Object)System.getProperty("os.name")));
    }

    public OS(String osName) {
        this.osName = osName;
    }

    public boolean isWindows() {
        return WINDOWS_PATTERN.matches(this.osName);
    }

    public boolean isLinux() {
        return LINUX_PATTERN.matches(this.osName);
    }

    public boolean isOSX() {
        return OSX_PATTERN.matches(this.osName);
    }

    public boolean isUnix() {
        return UNIX_PATTERN.matches(this.osName);
    }

    public String toString() {
        return this.osName;
    }
}

