/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.kleinod.os;

import de.pfabulist.kleinod.frex.Frex;
import de.pfabulist.roast.types.NonnullCheck;
import java.util.regex.Pattern;

public class OS {
    public static final OS UNIX = new OS("unix");
    public static final OS WINDOWS = new OS("windows");
    public static final OS OSX = new OS("Mac OS X");
    private static final Pattern UNIX_PATTERN = Frex.or((Frex[])new Frex[]{Frex.txt((String)"Linux"), Frex.txt((String)"Solaris"), Frex.txt((String)"SunOS"), Frex.txt((String)"HP-UX"), Frex.txt((String)"AIX"), Frex.txt((String)"FreeBSD"), Frex.txt((String)"Irix"), Frex.txt((String)"Digital Unix"), Frex.txt((String)"OSF1"), Frex.startsWith((String)"Mac OS X"), Frex.contains((String)"BSD"), Frex.contains((String)"nix"), Frex.contains((String)"nux")}).buildCaseInsensitivePattern();
    private static final Pattern WINDOWS_PATTERN = Frex.startsWith((String)"windows").buildCaseInsensitivePattern();
    private static final Pattern OSX_PATTERN = Frex.startsWith((String)"mac os x").buildCaseInsensitivePattern();
    private static final Pattern LINUX_PATTERN = Frex.contains((String)"linux").buildCaseInsensitivePattern();
    private final String osName;

    public OS() {
        this((String)NonnullCheck.n_((Object)System.getProperty("os.name")));
    }

    public OS(String osName) {
        this.osName = osName;
    }

    public boolean isWindows() {
        return WINDOWS_PATTERN.matcher(this.osName).matches();
    }

    public boolean isLinux() {
        return LINUX_PATTERN.matcher(this.osName).matches();
    }

    public boolean isOSX() {
        return OSX_PATTERN.matcher(this.osName).matches();
    }

    public boolean isUnix() {
        return UNIX_PATTERN.matcher(this.osName).matches();
    }

    public String toString() {
        return this.osName;
    }
}

