/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.lindwurm.niodav.Configuration;
import de.pfabulist.lindwurm.niodav.ConfigurationManager;
import de.pfabulist.lindwurm.niodav.FSFile;
import de.pfabulist.lindwurm.niodav.ResourceFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;

public class DefaultDavResourceFactory
implements DavResourceFactory {
    private final ConfigurationManager configurationManager;
    private final ResourceFactory resourceFactory;

    public DefaultDavResourceFactory(ConfigurationManager configManager, ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        this.configurationManager = configManager;
    }

    public DavResource createResource(DavResourceLocator resourceLocator, DavServletRequest request, DavServletResponse response) throws DavException {
        FSFile theReference;
        Configuration configuration = this.configurationManager.getConfigurationFor((HttpServletRequest)request);
        FSFile rootFolder = configuration.getRootFolder();
        if (resourceLocator.isRootLocation()) {
            return this.resourceFactory.createFolderResource(rootFolder, request.getDavSession(), this, resourceLocator);
        }
        String resourcePath = resourceLocator.getResourcePath();
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((theReference = rootFolder.addChild(resourcePath)) == null) {
            throw new DavException(404, "Not found : " + resourcePath);
        }
        return this.resourceFactory.createFileOrFolderResource(theReference, request.getDavSession(), this, resourceLocator);
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

