/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.lindwurm.niodav.FSFile;
import de.pfabulist.lindwurm.niodav.ResourceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.property.ResourceType;

public class FileDavResource
implements DavResource {
    private static final String LOCKTOKEN = "LOCKTOKEN";
    final FSFile file;
    final DavResourceFactory resourceFactory;
    final DavResourceLocator resourceLocator;
    final DavSession session;
    final ResourceFactory resFactory;
    private LockManager lockManager;
    private final DavPropertySet properties;

    FileDavResource(ResourceFactory aResFactory, FSFile aFile, DavSession aSession, DavResourceFactory aResourceFactory, DavResourceLocator aResourceLocator) {
        this.file = aFile;
        this.resourceFactory = aResourceFactory;
        this.resourceLocator = aResourceLocator;
        this.session = aSession;
        this.properties = new DavPropertySet();
        this.resFactory = aResFactory;
    }

    void createNewEmptyCollection() {
        this.file.mkdirs();
    }

    OutputStream openStream() throws IOException, DavException {
        return Files.newOutputStream(this.file.getPath(), new OpenOption[0]);
    }

    public String getComplianceClass() {
        return DavCompliance.concatComplianceClasses((String[])new String[]{"1", "2"});
    }

    public boolean exists() {
        return Files.exists(this.file.getPath(), new LinkOption[0]);
    }

    public boolean isCollection() {
        return Files.isDirectory(this.file.getPath(), new LinkOption[0]);
    }

    public String getDisplayName() {
        return this.file.getPath().getFileName().toString();
    }

    public DavResourceLocator getLocator() {
        return this.resourceLocator;
    }

    public String getResourcePath() {
        if (this.resourceLocator.isRootLocation()) {
            return "/" + this.file.getPath().getFileName().toString();
        }
        String resourcePath = this.resourceLocator.getResourcePath();
        if (!resourcePath.endsWith("/")) {
            return resourcePath + "/" + this.file.getPath().getFileName().toString();
        }
        return resourcePath + this.file.getPath().getFileName().toString();
    }

    public String getHref() {
        String href = this.resourceLocator.getHref(false);
        if (!href.endsWith("/")) {
            return href + "/" + this.file.getPath().getFileName().toString();
        }
        return href + this.file.getPath().getFileName().toString();
    }

    public long getModificationTime() {
        try {
            return Files.getLastModifiedTime(this.file.getPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public DavPropertyName[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public DavProperty<?> getProperty(DavPropertyName propertyName) {
        return this.properties.get(propertyName);
    }

    public DavPropertySet getProperties() {
        return this.properties;
    }

    public void setProperty(DavProperty<?> property) {
        this.properties.add(property);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        this.properties.remove(propertyName);
    }

    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatusResponse response = new MultiStatusResponse(this.getHref(), null);
        for (PropEntry propEntry : changeList) {
            int statusCode = 200;
            if (propEntry instanceof DavProperty) {
                response.add(((DavProperty)propEntry).getName(), statusCode);
                continue;
            }
            response.add((DavPropertyName)propEntry, statusCode);
        }
        return response;
    }

    public void move(DavResource destination) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            Files.move(this.file.getPath(), ((FileDavResource)destination).file.getPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new DavException(403);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isLockable(Type type, Scope scope) {
        return true;
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.lockManager.hasLock(LOCKTOKEN, (DavResource)this);
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return this.lockManager.getLock(type, scope, (DavResource)this);
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    public ActiveLock lock(LockInfo lockInfo) throws DavException {
        return this.lockManager.createLock(lockInfo, (DavResource)this);
    }

    public ActiveLock refreshLock(LockInfo lockInfo, String lockToken) throws DavException {
        return this.lockManager.refreshLock(lockInfo, lockToken, (DavResource)this);
    }

    public void unlock(String lockToken) throws DavException {
        this.lockManager.releaseLock(lockToken, (DavResource)this);
    }

    public void addLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public DavResourceFactory getFactory() {
        return this.resourceFactory;
    }

    public DavSession getSession() {
        return this.session;
    }

    public String getSupportedMethods() {
        String methods = "OPTIONS, GET, HEAD, TRACE, PROPFIND, PROPPATCH, COPY, LOCK, UNLOCK, POST, PUT, MOVE, DELETE";
        if (Files.isDirectory(this.file.getPath(), new LinkOption[0])) {
            methods = methods + ", MKCOL";
        }
        return methods;
    }

    public void spool(OutputContext outputContext) throws IOException {
        outputContext.setContentLength(Files.size(this.file.getPath()));
        outputContext.setModificationTime(Files.size(this.file.getPath()));
        if (outputContext.hasStream()) {
            try (InputStream theFis = Files.newInputStream(this.file.getPath(), new OpenOption[0]);){
                IOUtils.copyLarge((InputStream)theFis, (OutputStream)outputContext.getOutputStream());
            }
        }
    }

    public DavResource getCollection() {
        return this.resFactory.createFileOrFolderResource(this.file.parent(), this.session, this.resourceFactory, this.resourceLocator);
    }

    public void addMember(DavResource davResource, InputContext inputContext) throws DavException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public DavResourceIterator getMembers() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeMember(DavResource member) throws DavException {
        throw new UnsupportedOperationException("Not implemented");
    }

    Path getPath() {
        return this.file.getPath();
    }

    void initProperties() {
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        this.properties.add((DavProperty)new ResourceType(0));
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        String theLastModified = IOUtil.getLastModified((long)this.getModificationTime());
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)theLastModified));
        long contentLength = -1L;
        try {
            contentLength = Files.size(this.file.getPath());
        }
        catch (IOException e) {
            // empty catch block
        }
        if (contentLength > -1L) {
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)(contentLength + "")));
        } else {
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)"1000000000"));
        }
    }
}

