/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.lindwurm.niodav.DefaultDavSession;
import de.pfabulist.lindwurm.niodav.FSFile;
import de.pfabulist.lindwurm.niodav.FileDavResource;
import de.pfabulist.lindwurm.niodav.ResourceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.ResourceType;

public class FolderDavResource
extends FileDavResource {
    FolderDavResource(ResourceFactory aResFactory, FSFile aFile, DavSession aSession, DavResourceFactory aResourceFactory, DavResourceLocator aResourceLocator) {
        super(aResFactory, aFile, aSession, aResourceFactory, aResourceLocator);
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addMember(DavResource davResource, InputContext inputContext) throws DavException {
        FileDavResource fileResource = (FileDavResource)davResource;
        DefaultDavSession session = (DefaultDavSession)davResource.getSession();
        if (session.isPutRequest()) {
            try (OutputStream theStream = fileResource.openStream();){
                if (!inputContext.hasStream()) return;
                IOUtils.copyLarge((InputStream)inputContext.getInputStream(), (OutputStream)theStream);
                return;
            }
            catch (Exception e) {
                throw new DavException(500, (Throwable)e);
            }
        }
        try {
            fileResource.createNewEmptyCollection();
            return;
        }
        catch (Exception e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    @Override
    public DavResourceIterator getMembers() {
        final List<FSFile> members = this.file.listFiles();
        return new DavResourceIterator(){
            int position = 0;

            public void remove() {
                throw new UnsupportedOperationException("Not implemented");
            }

            public DavResource nextResource() {
                return this.next();
            }

            public int size() {
                return members.size();
            }

            public boolean hasNext() {
                return this.position < members.size();
            }

            public DavResource next() {
                return this.toResource((FSFile)members.get(this.position++));
            }

            DavResource toResource(FSFile file) {
                DavResourceLocator childLocator = FolderDavResource.this.resourceLocator.getFactory().createResourceLocator(FolderDavResource.this.resourceLocator.getPrefix(), FolderDavResource.this.resourceLocator.getHref(true) + FolderDavResource.this.file.getPath().getFileName().toString());
                return FolderDavResource.this.resFactory.createFileOrFolderResource(file, FolderDavResource.this.session, FolderDavResource.this.resourceFactory, childLocator);
            }
        };
    }

    @Override
    public void removeMember(DavResource member) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        FileDavResource theFileResource = (FileDavResource)member;
        try {
            Files.delete(theFileResource.file.getPath());
        }
        catch (IOException e) {
            throw new DavException(403, (Throwable)e);
        }
    }

    @Override
    public void spool(OutputContext outputContext) throws IOException {
        outputContext.setModificationTime(Files.getLastModifiedTime(this.file.getPath(), new LinkOption[0]).toMillis());
    }

    @Override
    void initProperties() {
        this.setProperty((DavProperty<?>)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        this.setProperty((DavProperty<?>)new ResourceType(1));
        this.setProperty((DavProperty<?>)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"1"));
        String theLastModified = IOUtil.getLastModified((long)this.getModificationTime());
        this.setProperty((DavProperty<?>)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)theLastModified));
        this.setProperty((DavProperty<?>)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)"1000000000"));
        long avail = 1000000000L;
        try {
            avail = Files.getFileStore(this.file.getPath()).getUsableSpace();
        }
        catch (IOException e) {
            // empty catch block
        }
        long used = 42000000L;
        try {
            used = Files.getFileStore(this.file.getPath()).getTotalSpace() - avail;
        }
        catch (IOException e) {
            // empty catch block
        }
        this.setProperty((DavProperty<?>)new DefaultDavProperty(DavPropertyName.create((String)"quota-used-bytes"), (Object)("" + used)));
        this.setProperty((DavProperty<?>)new DefaultDavProperty(DavPropertyName.create((String)"quota-available-bytes"), (Object)("" + avail)));
    }
}

