/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.kleinod.errors.Unchecked;
import de.pfabulist.kleinod.paths.Filess;
import de.pfabulist.lindwurm.niodav.NioConfigurationManager;
import de.pfabulist.lindwurm.niodav.NioDavServletFactory;
import java.nio.file.Path;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class NioDavServer {
    private int port;
    private Path path;
    private Server server;

    public NioDavServer(Path path, int port) {
        this.path = path;
        this.port = port;
        Filess.createDirectories((Path)path);
    }

    public NioDavServer start() {
        NioConfigurationManager configurationManager = new NioConfigurationManager(this.path, "");
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath("/");
        webAppContext.setBaseResource(Resource.newClassPathResource((String)"/webdavwebapp"));
        webAppContext.setDescriptor("WEB-INF/web.xml");
        webAppContext.setClassLoader(Server.class.getClassLoader());
        webAppContext.addServlet(new ServletHolder((Servlet)new NioDavServletFactory().create(configurationManager)), "/");
        this.server = new Server(this.port);
        this.server.setHandler((Handler)webAppContext);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw Unchecked.runtime((Exception)e);
        }
        return this;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NioDavServer() {
    }

    public void go(Path path, String mountName, int port) throws Exception {
        NioConfigurationManager configurationManager = new NioConfigurationManager(path, mountName);
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath("/");
        webAppContext.setBaseResource(Resource.newClassPathResource((String)"/webdavwebapp"));
        webAppContext.setDescriptor("WEB-INF/web.xml");
        webAppContext.setClassLoader(Server.class.getClassLoader());
        webAppContext.addServlet(new ServletHolder((Servlet)new NioDavServletFactory().create(configurationManager)), "/");
        Server server = new Server(port);
        server.setHandler((Handler)webAppContext);
        server.start();
    }
}

