/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.kleinod.errors.RunnableE;
import de.pfabulist.kleinod.errors.SupplierE;
import de.pfabulist.lindwurm.niodav.FSFile;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioFile
implements FSFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(NioFile.class);
    private final Path path;
    private FSFile parent;

    public NioFile(Path path) {
        this.path = path;
    }

    private static void swallowV(RunnableE r) {
        try {
            r.run();
        }
        catch (Throwable e) {
            LOGGER.warn("", e);
        }
    }

    private static <T, E extends Exception> T swallow(SupplierE<T, E> s, T otherwise) {
        try {
            return (T)s.get();
        }
        catch (Throwable e) {
            LOGGER.warn("", e);
            return otherwise;
        }
    }

    @Override
    public void mkdirs() {
        NioFile.swallowV(() -> {
            if (!Files.exists(this.path, new LinkOption[0])) {
                Files.createDirectories(this.path, new FileAttribute[0]);
            }
        });
    }

    @Override
    public List<FSFile> listFiles() {
        return NioFile.swallow(() -> {
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(this.path);){
                ArrayList<NioFile> kids = new ArrayList<NioFile>();
                for (Path kid : dir) {
                    NioFile kidwrapped = new NioFile(kid);
                    kidwrapped.setParent(this);
                    kids.add(kidwrapped);
                }
                ArrayList<NioFile> arrayList = kids;
                return arrayList;
            }
        }, Collections.emptyList());
    }

    @Override
    public FSFile parent() {
        return this.parent;
    }

    @Override
    public void setParent(FSFile aParent) {
        this.parent = aParent;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public FSFile addChild(String fileName) {
        NioFile proxy = new NioFile(this.path.resolve(fileName));
        proxy.setParent(this);
        return proxy;
    }
}

