/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.lindwurm.niodav.FSFile;
import de.pfabulist.lindwurm.niodav.FileDavResource;
import de.pfabulist.lindwurm.niodav.FolderDavResource;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;

class ResourceFactory {
    private final LockManager lockManager;

    public ResourceFactory(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    FileDavResource createFileResource(FSFile file, DavSession session, DavResourceFactory resourceFactory, DavResourceLocator resourceLocator) {
        FileDavResource fileDavResource = new FileDavResource(this, file, session, resourceFactory, resourceLocator);
        fileDavResource.addLockManager(this.lockManager);
        fileDavResource.initProperties();
        return fileDavResource;
    }

    public FolderDavResource createFolderResource(FSFile aFile, DavSession aSession, DavResourceFactory aResourceFactory, DavResourceLocator aResourceLocator) {
        FolderDavResource theResource = new FolderDavResource(this, aFile, aSession, aResourceFactory, aResourceLocator);
        theResource.addLockManager(this.lockManager);
        theResource.initProperties();
        return theResource;
    }

    public DavResource createFileOrFolderResource(FSFile file, DavSession session, DavResourceFactory resourceFactory, DavResourceLocator resourceLocator) {
        if (Files.isDirectory(file.getPath(), new LinkOption[0])) {
            return this.createFolderResource(file, session, resourceFactory, resourceLocator);
        }
        return this.createFileResource(file, session, resourceFactory, resourceLocator);
    }
}

