/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.lindwurm.niodav.Configuration;
import de.pfabulist.lindwurm.niodav.ConfigurationManager;
import de.pfabulist.lindwurm.niodav.ResourceFactory;
import java.nio.file.Path;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;

public class DefaultDavResourceFactory
implements DavResourceFactory {
    private final ConfigurationManager configurationManager;
    private final ResourceFactory resourceFactory;

    public DefaultDavResourceFactory(ConfigurationManager configManager, ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        this.configurationManager = configManager;
    }

    public DavResource createResource(DavResourceLocator resourceLocator, DavServletRequest request, DavServletResponse response) throws DavException {
        Path theReference;
        Configuration configuration = this.configurationManager.getConfigurationFor((HttpServletRequest)request);
        Path rootFolder = configuration.getRootFolder();
        if (resourceLocator.isRootLocation()) {
            return this.resourceFactory.createNioDavResource(rootFolder, request.getDavSession(), this, resourceLocator);
        }
        String resourcePath = resourceLocator.getResourcePath();
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((theReference = rootFolder.resolve(resourcePath)) == null) {
            throw new DavException(404, "Not found : " + resourcePath);
        }
        return this.resourceFactory.createNioDavResource(theReference, request.getDavSession(), this, resourceLocator);
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

