/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.kleinod.paths.Pathss;
import de.pfabulist.lindwurm.niodav.DefaultDavSession;
import de.pfabulist.lindwurm.niodav.ResourceFactory;
import de.pfabulist.lindwurm.niodav.Util;
import de.pfabulist.unchecked.Filess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.server.io.IOUtil;
import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceIterator;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.io.InputContext;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockInfo;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.PropEntry;
import org.apache.jackrabbit.webdav.property.ResourceType;

public class NioDavResource
implements DavResource {
    private static final String LOCKTOKEN = "LOCKTOKEN";
    final Path file;
    final DavResourceFactory resourceFactory;
    final DavResourceLocator resourceLocator;
    final DavSession session;
    final ResourceFactory resFactory;
    private LockManager lockManager;
    private final DavPropertySet properties;
    private final boolean isDirectory;

    NioDavResource(ResourceFactory resourceFactory, Path file, DavSession session, DavResourceFactory davResourceFactory, DavResourceLocator davResourceLocator) {
        this.file = file;
        this.resourceFactory = davResourceFactory;
        this.resourceLocator = davResourceLocator;
        this.session = session;
        this.properties = new DavPropertySet();
        this.resFactory = resourceFactory;
        this.isDirectory = Files.isDirectory(file, new LinkOption[0]);
    }

    public String getComplianceClass() {
        return DavCompliance.concatComplianceClasses((String[])new String[]{"1", "2"});
    }

    public boolean exists() {
        return Files.exists(this.file, new LinkOption[0]);
    }

    public boolean isCollection() {
        return this.isDirectory;
    }

    public String getDisplayName() {
        Path filename = this.file.getFileName();
        return filename == null ? "<root>" : filename.toString();
    }

    public DavResourceLocator getLocator() {
        return this.resourceLocator;
    }

    public String getResourcePath() {
        if (this.resourceLocator.isRootLocation()) {
            return "/" + this.file.getFileName().toString();
        }
        String resourcePath = this.resourceLocator.getResourcePath();
        if (!resourcePath.endsWith("/")) {
            return resourcePath + "/" + Util.getName(this.file);
        }
        return resourcePath + Util.getName(this.file);
    }

    public String getHref() {
        String href = this.resourceLocator.getHref(false);
        if (!href.endsWith("/")) {
            return href + "/" + Util.getName(this.file);
        }
        return href + Util.getName(this.file);
    }

    public long getModificationTime() {
        try {
            return Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public DavPropertyName[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public DavProperty<?> getProperty(DavPropertyName propertyName) {
        return this.properties.get(propertyName);
    }

    public DavPropertySet getProperties() {
        return this.properties;
    }

    public void setProperty(DavProperty<?> property) {
        this.properties.add(property);
    }

    public void removeProperty(DavPropertyName propertyName) throws DavException {
        this.properties.remove(propertyName);
    }

    public MultiStatusResponse alterProperties(List<? extends PropEntry> changeList) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatusResponse response = new MultiStatusResponse(this.getHref(), null);
        for (PropEntry propEntry : changeList) {
            int statusCode = 200;
            if (propEntry instanceof DavProperty) {
                DavProperty dprop = (DavProperty)propEntry;
                if (dprop.getName().equals((Object)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)"1").getName())) {
                    Object val = dprop.getValue();
                    System.out.println(dprop.getValue());
                    Filess.setLastModifiedTime((Path)this.file, (FileTime)FileTime.fromMillis(LocalDateTime.parse((String)dprop.getValue(), DateTimeFormatter.RFC_1123_DATE_TIME).toEpochSecond(ZoneOffset.ofTotalSeconds(0)) * 1000L));
                }
                response.add(dprop);
                continue;
            }
            response.add((DavPropertyName)propEntry, statusCode);
        }
        return response;
    }

    public void move(DavResource destination) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            Files.move(this.file, ((NioDavResource)destination).file, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new DavException(403);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            Files.copy(this.file, ((NioDavResource)destination).file, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new DavException(403);
        }
    }

    public boolean isLockable(Type type, Scope scope) {
        return true;
    }

    public boolean hasLock(Type type, Scope scope) {
        return this.lockManager.hasLock(LOCKTOKEN, (DavResource)this);
    }

    public ActiveLock getLock(Type type, Scope scope) {
        return this.lockManager.getLock(type, scope, (DavResource)this);
    }

    public ActiveLock[] getLocks() {
        ActiveLock[] activeLockArray;
        ActiveLock writeLock = this.getLock(Type.WRITE, Scope.EXCLUSIVE);
        if (writeLock != null) {
            ActiveLock[] activeLockArray2 = new ActiveLock[1];
            activeLockArray = activeLockArray2;
            activeLockArray2[0] = writeLock;
        } else {
            activeLockArray = new ActiveLock[]{};
        }
        return activeLockArray;
    }

    public ActiveLock lock(LockInfo lockInfo) throws DavException {
        return this.lockManager.createLock(lockInfo, (DavResource)this);
    }

    public ActiveLock refreshLock(LockInfo lockInfo, String lockToken) throws DavException {
        return this.lockManager.refreshLock(lockInfo, lockToken, (DavResource)this);
    }

    public void unlock(String lockToken) throws DavException {
        this.lockManager.releaseLock(lockToken, (DavResource)this);
    }

    public void addLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public DavResourceFactory getFactory() {
        return this.resourceFactory;
    }

    public DavSession getSession() {
        return this.session;
    }

    public String getSupportedMethods() {
        String methods = "OPTIONS, GET, HEAD, TRACE, PROPFIND, PROPPATCH, COPY, LOCK, UNLOCK, POST, PUT, MOVE, DELETE";
        if (this.isDirectory) {
            methods = methods + ", MKCOL";
        }
        return methods;
    }

    public void spool(OutputContext outputContext) throws IOException {
        outputContext.setModificationTime(Files.getLastModifiedTime(this.file, new LinkOption[0]).toMillis());
        if (!this.isDirectory) {
            outputContext.setContentLength(Files.size(this.file));
            if (outputContext.hasStream()) {
                try (InputStream theFis = Files.newInputStream(this.file, new OpenOption[0]);){
                    IOUtils.copyLarge((InputStream)theFis, (OutputStream)outputContext.getOutputStream());
                }
            }
        }
    }

    public DavResource getCollection() {
        return this.resFactory.createNioDavResource(this.file.getParent(), this.session, this.resourceFactory, this.resourceLocator);
    }

    public void addMember(DavResource davResource, InputContext inputContext) throws DavException {
        if (this.isDirectory) {
            NioDavResource fileResource = (NioDavResource)davResource;
            DefaultDavSession session = (DefaultDavSession)davResource.getSession();
            if (session.isPutRequest()) {
                this.createFile(inputContext, fileResource);
            } else {
                this.createDir(fileResource);
            }
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private void createDir(NioDavResource fileResource) throws DavException {
        try {
            if (!Files.exists(fileResource.file, new LinkOption[0])) {
                Files.createDirectories(fileResource.file, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    private void createFile(InputContext inputContext, NioDavResource fileResource) throws DavException {
        try (OutputStream theStream = Files.newOutputStream(fileResource.file, new OpenOption[0]);){
            if (inputContext.hasStream()) {
                IOUtils.copyLarge((InputStream)inputContext.getInputStream(), (OutputStream)theStream);
            }
        }
        catch (Exception e) {
            throw new DavException(500, (Throwable)e);
        }
    }

    public DavResourceIterator getMembers() {
        if (this.isDirectory) {
            final ArrayList<Path> members = new ArrayList<Path>();
            try (DirectoryStream<Path> dir = Files.newDirectoryStream(this.file);){
                for (Path kid : dir) {
                    members.add(kid);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new DavResourceIterator(){
                int position = 0;

                public void remove() {
                    throw new UnsupportedOperationException("Not implemented");
                }

                public DavResource nextResource() {
                    return this.next();
                }

                public int size() {
                    return members.size();
                }

                public boolean hasNext() {
                    return this.position < members.size();
                }

                public DavResource next() {
                    return this.toResource((Path)members.get(this.position++));
                }

                DavResource toResource(Path file) {
                    DavResourceLocator childLocator = NioDavResource.this.resourceLocator.getFactory().createResourceLocator(NioDavResource.this.resourceLocator.getPrefix(), NioDavResource.this.resourceLocator.getHref(true) + Util.getName(NioDavResource.this.file));
                    return NioDavResource.this.resFactory.createNioDavResource(file, NioDavResource.this.session, NioDavResource.this.resourceFactory, childLocator);
                }
            };
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeMember(DavResource member) throws DavException {
        if (this.isDirectory) {
            if (!this.exists()) {
                throw new DavException(404);
            }
            NioDavResource theFileResource = (NioDavResource)member;
            try {
                Pathss.deleteRecursive((Path)theFileResource.file);
            }
            catch (Exception e) {
                throw new DavException(403, (Throwable)e);
            }
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    void initProperties() {
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.DISPLAYNAME, (Object)this.getDisplayName()));
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETLASTMODIFIED, (Object)IOUtil.getLastModified((long)this.getModificationTime())));
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.CREATIONDATE, (Object)IOUtil.getCreated((long)this.getCreationDate())));
        this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.GETCONTENTLENGTH, (Object)this.getDavSize()));
        if (this.isDirectory) {
            this.properties.add((DavProperty)new ResourceType(1));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"1"));
            long avail = this.getUsableSpace();
            long used = this.getUsedBytes(avail);
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.create((String)"quota-used-bytes"), (Object)("" + used)));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.create((String)"quota-available-bytes"), (Object)("" + avail)));
        } else {
            this.properties.add((DavProperty)new ResourceType(0));
            this.properties.add((DavProperty)new DefaultDavProperty(DavPropertyName.ISCOLLECTION, (Object)"0"));
        }
    }

    private long getUsedBytes(long avail) {
        try {
            return Files.getFileStore(this.file).getTotalSpace() - avail;
        }
        catch (IOException e) {
            return 42000000L;
        }
    }

    private long getUsableSpace() {
        try {
            return Files.getFileStore(this.file).getUsableSpace();
        }
        catch (IOException e) {
            return 1000000000L;
        }
    }

    private String getDavSize() {
        if (!this.isDirectory) {
            try {
                long size = Files.size(this.file);
                if (size > -1L) {
                    return "" + size;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "1000000000";
    }

    private long getCreationDate() {
        try {
            return Files.readAttributes(this.file, BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

