/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niodav;

import de.pfabulist.lindwurm.niodav.ConfigurationManager;
import de.pfabulist.lindwurm.niodav.DefaultDavLocatorFactory;
import de.pfabulist.lindwurm.niodav.DefaultDavResourceFactory;
import de.pfabulist.lindwurm.niodav.DefaultSavSessionProvider;
import de.pfabulist.lindwurm.niodav.NioConfigurationManager;
import de.pfabulist.lindwurm.niodav.NioDavServlet;
import de.pfabulist.lindwurm.niodav.ResourceFactory;
import de.pfabulist.unchecked.Filess;
import de.pfabulist.unchecked.Unchecked;
import java.nio.file.Path;
import javax.servlet.Servlet;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.lock.SimpleLockManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class NioDavServer {
    private int port;
    private Path path;
    private Server server;

    public NioDavServer(Path path, int port) {
        this.path = path;
        this.port = port;
        Filess.createDirectories((Path)path);
    }

    public NioDavServer start() {
        NioConfigurationManager configurationManager = new NioConfigurationManager(this.path, "");
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath("/");
        webAppContext.setBaseResource(Resource.newClassPathResource((String)"/webdavwebapp"));
        webAppContext.setDescriptor("WEB-INF/web.xml");
        webAppContext.setClassLoader(Server.class.getClassLoader());
        webAppContext.addServlet(new ServletHolder((Servlet)this.createServlet(configurationManager)), "/");
        this.server = new Server(this.port);
        this.server.setHandler((Handler)webAppContext);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw Unchecked.u((Throwable)e);
        }
        return this;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public NioDavServer() {
    }

    private NioDavServlet createServlet(ConfigurationManager configurationManager) {
        NioDavServlet easyDavServlet = new NioDavServlet();
        easyDavServlet.setDavSessionProvider(new DefaultSavSessionProvider());
        easyDavServlet.setLocatorFactory((DavLocatorFactory)new DefaultDavLocatorFactory());
        easyDavServlet.setResourceFactory(new DefaultDavResourceFactory(configurationManager, new ResourceFactory((LockManager)new SimpleLockManager())));
        return easyDavServlet;
    }
}

