/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.matcher;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class WatchKeyMatcher
extends TypeSafeMatcher<WatchKey> {
    private final Path file;
    private final WatchEvent.Kind<Path> kind;

    public WatchKeyMatcher(Path file, WatchEvent.Kind<Path> kind) {
        this.file = file;
        this.kind = kind;
    }

    public boolean matchesSafely(WatchKey key) {
        if (key == null) {
            return false;
        }
        if (!key.isValid()) {
            return false;
        }
        if (!this.file.getParent().equals(key.watchable())) {
            return false;
        }
        List<WatchEvent<?>> events = key.pollEvents();
        if (events.size() != 1) {
            return false;
        }
        WatchEvent<?> event = events.get(0);
        if (!this.file.getFileName().equals(event.context())) {
            return false;
        }
        return event.kind().equals(this.kind);
    }

    protected void describeMismatchSafely(WatchKey key, Description mismatchDescription) {
        if (key == null) {
            mismatchDescription.appendText("key is null");
            return;
        }
        if (!key.isValid()) {
            mismatchDescription.appendText("key is not valid");
            return;
        }
        if (!this.file.getParent().equals(key.watchable())) {
            mismatchDescription.appendText("key watches the wrong dir. expected: " + this.file.getParent() + " got: " + key.watchable());
            return;
        }
        mismatchDescription.appendText("key reports wrong # of events OR key reports wrong file OR wrong event kind");
    }

    public void describeTo(Description description) {
        description.appendText("watchkey is not correct");
    }

    @Factory
    public static <T> Matcher<WatchKey> correctKey(Path file, WatchEvent.Kind<Path> kind) {
        return new WatchKeyMatcher(file, kind);
    }
}

