/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Ref;
import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.matcher.WatchEventMatcher;
import de.pfabulist.lindwurm.niotest.matcher.WatchKeyMatcher;
import de.pfabulist.lindwurm.niotest.tests.PathTest10PathWithContentIT;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsEmptyCollection;
import org.hamcrest.core.Is;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest11WatcherIT
extends PathTest10PathWithContentIT {
    private WatchService watchService;
    long watcherSleep = 1000L;

    @Test(expected=ProviderMismatchException.class)
    public void testRegisterOtherPath() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        WatchService ws = this.getOther().getFileSystem().newWatchService();
        this.getPathPABf().register(ws, StandardWatchEventKinds.ENTRY_DELETE);
    }

    @Test
    public void testWatchADelete() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeDeleted = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test(timeout=60000L)
    public void testWatchADeleteTake() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeDeleted = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        MatcherAssert.assertThat((Object)this.waitForWatchService().take(), WatchKeyMatcher.correctKey(toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test(timeout=60000L)
    public void testWatchADeletePollTimeOut() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeDeleted = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.delete(toBeDeleted);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(1000L, TimeUnit.MILLISECONDS), WatchKeyMatcher.correctKey(toBeDeleted, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test(timeout=3000L)
    public void testPollWithTimeoutTimesOut() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        this.getWatchService().poll(1000L, TimeUnit.MILLISECONDS);
    }

    @Test(expected=ClosedWatchServiceException.class)
    public void testRegisterOnClosedWatchService() throws IOException {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        WatchService watcher = this.FS.newWatchService();
        watcher.close();
        this.getPathPAd().register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
    }

    @Test(expected=ClosedWatchServiceException.class)
    public void testRegisterWatchServiceOfClosedFS() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.isClosable(), (Matcher)Is.is((Object)true));
        this.getClosedBd().register(this.getClosedFSWatchService(), StandardWatchEventKinds.ENTRY_DELETE);
    }

    @Test
    public void testWatchADeleteFromAMove() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeMoved = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_DELETE);
        Files.move(toBeMoved, this.getPathPB(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(toBeMoved, StandardWatchEventKinds.ENTRY_DELETE));
    }

    @Test
    public void testWatchAModify() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeModified = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        Thread.sleep(20000L);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(toBeModified, StandardWatchEventKinds.ENTRY_MODIFY));
    }

    @Test
    public void testReadIsNotModify() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeModified = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.readAllBytes(toBeModified);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWatchForOtherEventCatchesNothing() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeModified = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWatchInOtherDirCatchesNothing() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.getPathPAf();
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), (Matcher)Matchers.nullValue());
    }

    @Test(timeout=90000L)
    public void testNotResetWatchKeyDoesNotQue() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.createPathWAf();
        WatchKey key = this.waitForWatchService().take();
        key.pollEvents();
        this.createPathWBf();
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), (Matcher)Matchers.nullValue());
    }

    @Test(timeout=90000L)
    public void testResetWatchKeyDoesQue() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        this.createPathWAf();
        WatchKey key = this.waitForWatchService().take();
        key.pollEvents();
        key.reset();
        Path file = this.createPathWBf();
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(file, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    public void testWatchSeveralEvents() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeModified = this.createPathWAf();
        Path toBeCreated = this.getPathWB();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        Files.write(toBeCreated, CONTENT_OTHER, new OpenOption[0]);
        WatchKey key = this.waitForWatchService().poll();
        MatcherAssert.assertThat((Object)key, (Matcher)CoreMatchers.notNullValue());
        List<WatchEvent<?>> watchEvents = key.pollEvents();
        MatcherAssert.assertThat(watchEvents, (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{WatchEventMatcher.isEvent(toBeModified, StandardWatchEventKinds.ENTRY_MODIFY), WatchEventMatcher.isEvent(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE)}));
    }

    @Test
    public void testWatchSeveralEventsMultipleDirs() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeCreated = this.getPathWB();
        Path otherDir = this.createPathWAd();
        Path toBeCreated2 = this.getPathWAB();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        otherDir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeCreated, CONTENT_OTHER, new OpenOption[0]);
        Thread.sleep(2000L);
        Files.write(toBeCreated2, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), (Matcher)CoreMatchers.anyOf(WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE), WatchKeyMatcher.correctKey(toBeCreated2, StandardWatchEventKinds.ENTRY_CREATE)));
        MatcherAssert.assertThat((Object)this.getWatchService().poll(), (Matcher)CoreMatchers.anyOf(WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE), WatchKeyMatcher.correctKey(toBeCreated2, StandardWatchEventKinds.ENTRY_CREATE)));
    }

    @Test
    public void testWatchACreateBy2WatchServies() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeCreated = this.getPathWA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        WatchService watchService2 = this.FS.newWatchService();
        this.createPathW().register(watchService2, StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeCreated, CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
        MatcherAssert.assertThat((Object)watchService2.poll(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    public void testWatchACreate() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeCreated = this.getPathWA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.write(toBeCreated, CONTENT, new OpenOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    public void testWatchACreateDir() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeCreated = this.getPathWA();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.createDirectory(toBeCreated, new FileAttribute[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(toBeCreated, StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    public void testWatchACreateFromCopy() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.copy(this.getPathPAf(), this.getPathWA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(this.getPathWA(), StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    public void testWatchACreateFromMove() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        Files.move(this.getPathPAf(), this.getPathWA(), new CopyOption[0]);
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(this.getPathWA(), StandardWatchEventKinds.ENTRY_CREATE));
    }

    @Test
    public void testCanceledWatchKeyDoesNotWatch() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        WatchKey key = this.watcherSetup(StandardWatchEventKinds.ENTRY_CREATE);
        key.cancel();
        this.createPathWAf();
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWatchATruncate() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path file = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
        MatcherAssert.assertThat((Object)this.waitForWatchService().poll(), WatchKeyMatcher.correctKey(file, StandardWatchEventKinds.ENTRY_MODIFY));
    }

    @Test
    public void testTakeBlocks() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        final WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        final Ref interrupted = Ref.valueOf((Object)false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    watcher.take();
                }
                catch (InterruptedException | ClosedWatchServiceException exception) {
                }
                finally {
                    interrupted.set((Object)true);
                }
            }
        }).start();
        Thread.sleep(1000L);
        MatcherAssert.assertThat((Object)interrupted.get(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testCloseAWatchServiceRelasesBlockedTreads() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        final WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        final Ref interrupted = Ref.valueOf((Object)false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    watcher.take();
                }
                catch (InterruptedException e) {
                }
                catch (ClosedWatchServiceException e) {
                    interrupted.set((Object)true);
                }
            }
        }).start();
        Thread.sleep(2000L);
        watcher.close();
        Thread.sleep(1000L);
        MatcherAssert.assertThat((Object)interrupted.get(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testCloseAWatchServiceCancelsKeys() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        WatchService watcher = dir.getFileSystem().newWatchService();
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        watcher.close();
        Thread.sleep(this.getWatcherSleep());
        MatcherAssert.assertThat((Object)key.isValid(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testPollAnEmptyWatchServiceReturnsNull() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        MatcherAssert.assertThat((Object)watcher.poll(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testWatchKeyPollEventsEmptiesQue() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPA();
        Path toBeDeleted = this.getPathPABf();
        WatchService watcher = dir.getFileSystem().newWatchService();
        dir.register(watcher, StandardWatchEventKinds.ENTRY_DELETE);
        Thread.sleep(1000L);
        Files.delete(toBeDeleted);
        Thread.sleep(this.getWatcherSleep());
        WatchKey watchKey = watcher.poll();
        watchKey.pollEvents();
        MatcherAssert.assertThat(watchKey.pollEvents(), (Matcher)IsEmptyCollection.empty());
    }

    @Test
    public void testDeleteWatchedDirCancelsKeys() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        WatchService watcher = dir.getFileSystem().newWatchService();
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Files.delete(dir);
        Thread.sleep(this.getWatcherSleep());
        MatcherAssert.assertThat((Object)key.isValid(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testMovedWatchedDirCancelsKeys() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        WatchService watcher = dir.getFileSystem().newWatchService();
        WatchKey key = dir.register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        Files.move(dir, this.getPathPB(), new CopyOption[0]);
        Thread.sleep(this.getWatcherSleep());
        MatcherAssert.assertThat((Object)key.isValid(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testWatchTwoModifiesOneKey() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsWatchService(), (Matcher)Is.is((Object)true));
        Path toBeModified = this.createPathWAf();
        this.watcherSetup(StandardWatchEventKinds.ENTRY_MODIFY);
        Files.write(toBeModified, CONTENT_OTHER, new OpenOption[0]);
        Files.write(toBeModified, CONTENT, new OpenOption[0]);
        WatchKey key = this.waitForWatchService().poll();
        MatcherAssert.assertThat((Object)key, (Matcher)CoreMatchers.notNullValue());
        List<WatchEvent<?>> watchEvents = key.pollEvents();
        MatcherAssert.assertThat(watchEvents, (Matcher)CoreMatchers.hasItems((Matcher[])new Matcher[]{WatchEventMatcher.isEvent(toBeModified, StandardWatchEventKinds.ENTRY_MODIFY)}));
    }

    public long getWatcherSleep() {
        return this.watcherSleep;
    }

    public Path createPathWAf() throws IOException {
        Path ret = this.getPathWA();
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path createPathWBf() throws IOException {
        Path ret = this.getPathWB();
        Files.write(ret, CONTENT, standardOpen);
        return ret;
    }

    public Path getPathWAB() throws IOException {
        return this.getPathWA().resolve(this.nameStr[1]);
    }

    public Path createPathWAd() throws IOException {
        Path ret = this.getPathWA();
        Files.createDirectories(ret, new FileAttribute[0]);
        return ret;
    }

    public Path getPathWA() throws IOException {
        return this.createPathW().resolve(this.nameStr[0]);
    }

    public Path getPathWB() throws IOException {
        return this.createPathW().resolve(this.nameStr[1]);
    }

    public Path createPathW() throws IOException {
        Path ret = this.emptyDir().resolve(this.nameStr[3]);
        Files.createDirectories(ret, new FileAttribute[0]);
        return ret;
    }

    public WatchService getWatchService() {
        return this.watchService;
    }

    public WatchService waitForWatchService() throws InterruptedException {
        Thread.sleep(this.getWatcherSleep());
        return this.watchService;
    }

    WatchKey watcherSetup(WatchEvent.Kind<Path> ... kinds) throws IOException {
        this.watchService = this.FS.newWatchService();
        return this.createPathW().register(this.watchService, kinds);
    }
}

