/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.text.Strings;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.tests.PathTest16PosixIT;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest17WindowsPathIT
extends PathTest16PosixIT {
    @Test
    public void testCaseIgnorantPath() {
        Assume.assumeThat((Object)(this.nameStrCase == null ? 1 : 0), (Matcher)Is.is((Object)false));
        for (int i = 0; i < 10; ++i) {
            MatcherAssert.assertThat((Object)this.getPathA().resolve(this.nameStr[i]), (Matcher)Is.is((Object)this.getPathA().resolve(this.nameStrCase[i])));
        }
    }

    @Test
    public void testHashCodeMixedCase() throws IOException {
        Assume.assumeThat((Object)(this.nameStrCase == null ? 1 : 0), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.getPathPA().resolve(this.nameStrCase[1]).hashCode(), (Matcher)Is.is((Object)this.getPathPAB().hashCode()));
    }

    @Test
    public void testExistenceMixedCase() throws IOException {
        Assume.assumeThat((Object)(this.nameStrCase == null ? 1 : 0), (Matcher)Is.is((Object)false));
        this.getPathPABf();
        MatcherAssert.assertThat((Object)Files.exists(this.getPathPA().resolve(this.nameStrCase[1]), new LinkOption[0]), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testOverwriteMixedCase() throws IOException {
        Assume.assumeThat((Object)(this.nameStrCase == null ? 1 : 0), (Matcher)Is.is((Object)false));
        this.getPathPABf();
        Files.write(this.getPathPA().resolve(this.nameStrCase[1]), CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(this.getPathPAB()), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testRememberedPath() throws IOException {
        Assume.assumeThat((Object)(this.nameStrCase == null ? 1 : 0), (Matcher)Is.is((Object)false));
        this.getPathPAd();
        Files.write(this.getPathPA().resolve(this.nameStrCase[1]), CONTENT, new OpenOption[0]);
        try (DirectoryStream<Path> dstr = Files.newDirectoryStream(this.getPathPA());){
            Path kid = dstr.iterator().next();
            MatcherAssert.assertThat((Object)kid, (Matcher)Is.is((Object)this.getPathPAB()));
            MatcherAssert.assertThat((Object)kid.toString(), (Matcher)IsNot.not((Matcher)Is.is((Object)this.getPathPAB().toString())));
        }
    }

    @Test
    public void testOverwriteDoesNotOverwriteRememberedName() throws IOException {
        Assume.assumeThat((Object)(this.nameStrCase == null ? 1 : 0), (Matcher)Is.is((Object)false));
        this.getPathPABf();
        Files.write(this.getPathPA().resolve(this.nameStrCase[1]), CONTENT_OTHER, new OpenOption[0]);
        try (DirectoryStream<Path> dstr = Files.newDirectoryStream(this.getPathPA());){
            Path kid = dstr.iterator().next();
            MatcherAssert.assertThat((Object)kid, (Matcher)Is.is((Object)this.getPathPAB()));
            MatcherAssert.assertThat((Object)kid.toString(), (Matcher)Is.is((Object)this.getPathPAB().toString()));
        }
    }

    @Test
    public void testWindowsBase() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\", new String[0]).isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testWindowsJustRootComponentIsRelative() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:", new String[0]).isAbsolute(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testWindowsRelativeWithRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:foo", new String[0]).isAbsolute(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testWindowsFilenameOfPathWithRootComponentHasNoRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo\\duh", new String[0]).getFileName(), (Matcher)Is.is((Object)this.FS.getPath("duh", new String[0])));
    }

    @Test
    public void testWindowsToAbsoluteWithoutRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo\\duh", new String[0]).getFileName(), (Matcher)Is.is((Object)this.FS.getPath("duh", new String[0])));
    }

    @Test
    public void testWindowsDifferentRootComponentResolvesToArgument() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).resolve("D:duh"), (Matcher)Is.is((Object)this.FS.getPath("D:duh", new String[0])));
    }

    @Test
    public void testWindowsSameRootComponentResolves() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).resolve("C:duh"), (Matcher)Is.is((Object)this.FS.getPath("C:\\foo\\duh", new String[0])));
    }

    @Test
    public void testWindowsImpliedRootComponentResolvesNot() {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\foo", new String[0]).resolve("C:duh"), (Matcher)Is.is((Object)this.FS.getPath("C:duh", new String[0])));
    }

    @Test
    public void testWindowsNoRootComponentResolves() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).resolve("duh"), (Matcher)Is.is((Object)this.FS.getPath("C:\\foo\\duh", new String[0])));
    }

    @Test
    public void testWindowsCaseDrive() {
        MatcherAssert.assertThat((Object)this.FS.getPath("X:\\foo", new String[0]), (Matcher)Is.is((Object)this.FS.getPath("x:\\foo", new String[0])));
    }

    @Test
    public void testWindowsRootOfDefaultIsC() {
        MatcherAssert.assertThat((Object)this.FS.getPath("", new String[0]).toAbsolutePath().getRoot(), (Matcher)Is.is((Object)this.FS.getPath("C:\\", new String[0])));
    }

    @Test
    public void testWindowsGetFileNameHasNoRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:\\foo", new String[0]).getFileName().toString().startsWith("C:"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testWindowsNoRootComponentGetRootHasNoRootComponent() {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\foo", new String[0]).getRoot(), (Matcher)Is.is((Object)this.FS.getPath("\\", new String[0])));
    }

    @Test
    public void testWindowsImpliedRootComponentPathExistsOnC() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath(this.getPathPABf().toString().substring(2), new String[0]), PathExists.exists());
    }

    @Test
    public void testWindowsIsSameFileShowsImpliedRootComponentIsC() throws IOException {
        Path one = this.getPathPABf();
        Path two = this.FS.getPath(one.toString().substring(2), new String[0]);
        MatcherAssert.assertThat((Object)this.FS.provider().isSameFile(one, two), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testWindowsRealFileOfImpliedIsWithC() throws IOException {
        Path one = this.getPathPABf();
        Path two = this.FS.getPath(one.toString().substring(2), new String[0]);
        MatcherAssert.assertThat((Object)two.toRealPath(new LinkOption[0]), (Matcher)Is.is((Object)one));
    }

    @Test
    public void testWindowsForwardIsBackwardSlash() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("C:/", new String[0]), (Matcher)Is.is((Object)this.FS.getPath("C:\\", new String[0])));
    }

    @Test(expected=InvalidPathException.class)
    public void testWindowsdNoSuchDrive() throws IOException {
        this.FS.getPath("5:", new String[0]);
    }

    @Test
    public void testWindowsUNC1() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\foo\\ho", new String[0]).getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test(expected=InvalidPathException.class)
    public void testWindowsUNCNoHostName() throws IOException {
        this.FS.getPath("\\\\", new String[0]);
    }

    @Test(expected=InvalidPathException.class)
    public void testWindowsdUNCNoShareName() throws IOException {
        this.FS.getPath("\\\\localhost", new String[0]);
    }

    @Test
    public void testWindowsdUNCPlenty() throws IOException {
        this.FS.getPath("\\//////\\\\localhost\\////foo", new String[0]);
    }

    @Test
    public void testWindowsUNCSlash() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("//mach/foo/ho", new String[0]).getNameCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void testWindowsUNCAbsolute() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\foo", new String[0]).isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testWindowsUNCAbsolute2() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\C$", new String[0]).isAbsolute(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testWindowsUNCRoot() throws IOException {
        MatcherAssert.assertThat((Object)this.FS.getPath("\\\\mach\\C$", new String[0]).getRoot(), (Matcher)Is.is((Object)this.FS.getPath("\\\\mach\\C$\\", new String[0])));
    }

    @Test
    public void testWindowsIllegalChars() {
        String ill = "?<>:*|\"";
        boolean thrown = false;
        for (int i = 0; i < ill.length(); ++i) {
            try {
                this.getPathAB().resolve("a" + ill.charAt(i));
            }
            catch (Exception e) {
                thrown = true;
            }
            MatcherAssert.assertThat((String)("illegal char " + ill.charAt(i) + " did not throw"), (Object)thrown, (Matcher)Is.is((Object)true));
        }
    }

    @Test
    public void testWindowsUNCToLocal() throws IOException {
        Assume.assumeThat((Object)this.capabilities.canSeeLocalUNCShares(this.FS), (Matcher)Is.is((Object)true));
        Path file = this.getPathPAf();
        Path unc = this.FS.getPath("\\\\localhost\\C$" + file.toString().substring(2), new String[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(unc), (Matcher)Is.is((Object)CONTENT));
    }

    @Test(expected=FileSystemException.class)
    public void testWindowsNul() throws IOException {
        Files.write(this.getPathPAd().resolve("nul"), CONTENT, new OpenOption[0]);
    }

    @Test
    public void testWindowsDeleteIfEsdfxistsRecreate() throws IOException {
        Path path = this.getPathPAB();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (SeekableByteChannel ch = Files.newByteChannel(path, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);){
            ch.write(ByteBuffer.wrap(Strings.getBytes((String)"hallo")));
            Files.delete(path);
            ch.write(ByteBuffer.wrap(Strings.getBytes((String)"duh")));
        }
        MatcherAssert.assertThat((Object)Files.exists(path, new LinkOption[0]), (Matcher)Is.is((Object)false));
    }
}

