/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.tests.PathTest18FileChannelsIT;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest19HardLinksIT
extends PathTest18FileChannelsIT {
    @Test
    public void testHardLinkCreate() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        MatcherAssert.assertThat((Object)link, PathExists.exists());
    }

    @Test
    public void testHardLinkChangeOneChangesTheOther() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        Files.write(link, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(orig), (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testHardLinkDeleteOrigDoesNotAffectTheOther() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        Files.delete(orig);
        MatcherAssert.assertThat((Object)Files.readAllBytes(link), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkDeleteLinkDoesNotAffectTheOther() throws IOException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        Files.delete(link);
        MatcherAssert.assertThat((Object)Files.readAllBytes(orig), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testHardLinkModifyOneModifiedDateOfOtherChanged() throws IOException, InterruptedException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
        FileTime before = Files.getLastModifiedTime(orig, new LinkOption[0]);
        Thread.sleep(1000L);
        Files.write(link, CONTENT_OTHER, new OpenOption[0]);
        MatcherAssert.assertThat((Object)Files.getLastModifiedTime(orig, new LinkOption[0]), (Matcher)Matchers.greaterThan((Comparable)before));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testHardLinkToExistingFileThrows() throws IOException, InterruptedException {
        Path orig = this.getPathPABf();
        Path link = this.getPathPACf();
        Files.createLink(link, orig);
    }

    @Test(expected=Exception.class)
    public void testHardLinkToOtherThrows() throws IOException {
        Assume.assumeThat((Object)this.capabilities.has2ndFileSystem(), (Matcher)Is.is((Object)true));
        Path orig = this.getPathOtherPAf();
        Path link = this.getPathPAC();
        Files.createLink(link, orig);
    }
}

