/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.Utils;
import de.pfabulist.lindwurm.niotest.matcher.IteratorMatcher;
import de.pfabulist.lindwurm.niotest.matcher.PathAbsolute;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.matcher.PathIsDirectory;
import de.pfabulist.lindwurm.niotest.tests.PathTest1NoContentIT;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest2DirIT
extends PathTest1NoContentIT {
    @Test
    public void testAAA2HasAPlayfield() throws Exception {
        Assert.assertThat((String)"assign a playfield", (Object)this.getPlay(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testDefaultIsDir() throws Exception {
        Assert.assertThat((Object)this.getDefaultPath(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testContentOfNonEmptyDir() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.nonEmptyDir());){
            Assert.assertThat((Object)Utils.getSize(stream), (Matcher)Is.is((Object)this.getKidCount()));
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testIteratorCanOnlyBeCalledOnceOnDirStream() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getPathPAd());){
            stream.iterator();
            stream.iterator();
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testDirStreamIteratorHasNoRemove() throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.getPathPAd());){
            stream.iterator().remove();
        }
    }

    @Test
    public void testContentOfNonEmptyDirFiltered() throws IOException {
        Path path = this.nonEmptyDir();
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){
            boolean first = true;

            @Override
            public boolean accept(Path entry) throws IOException {
                if (this.first) {
                    this.first = false;
                    return false;
                }
                return true;
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
            Assert.assertThat((Object)Utils.getSize(stream), (Matcher)Is.is((Object)(this.getKidCount() - 1)));
        }
    }

    @Test
    public void testNewDirIsInParentsDirStream() throws IOException {
        Path dir = this.getPathPA();
        Files.createDirectory(dir, new FileAttribute[0]);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir.getParent());){
            Assert.assertThat((Object)dir, IteratorMatcher.isIn(kids));
        }
    }

    @Test
    public void testNewDirectoryExists() throws IOException {
        Path newDir = this.getPathPA();
        Files.createDirectory(newDir, new FileAttribute[0]);
        Assert.assertThat((Object)newDir, PathExists.exists());
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateDirectoryTwiceThrows() throws IOException {
        Path newDir = this.getPathPA();
        Files.createDirectory(newDir, new FileAttribute[0]);
        Files.createDirectory(newDir, new FileAttribute[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void testCreateDirectoryWithoutExistingParantFails() throws IOException {
        Files.createDirectory(this.getPathPAB(), new FileAttribute[0]);
    }

    @Test(expected=FileSystemException.class)
    public void testCreateDirectoryWithInNoDirectoryFails() throws IOException {
        Files.createDirectory(this.getPathPAf().resolve(this.nameStr[2]), new FileAttribute[0]);
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateDirectoryRoot() throws IOException {
        Files.createDirectory(this.getRoot(), new FileAttribute[0]);
    }

    @Test
    public void testRootisADir() throws IOException {
        Assert.assertThat((Object)this.getRoot(), PathIsDirectory.isDirectory());
    }

    @Test
    public void testDefaultExists() throws Exception {
        Assert.assertThat((Object)this.getDefaultPath(), PathExists.exists());
    }

    @Test
    public void testNonExistingAbsolutePathIsNotADirectory() throws IOException {
        Assert.assertThat((Object)this.getPathPA(), (Matcher)Matchers.not(PathIsDirectory.isDirectory()));
    }

    @Test
    public void testNonExistingRelativePathIsNotADirectory() throws IOException {
        Assert.assertThat((Object)this.getPathA(), (Matcher)Matchers.not(PathIsDirectory.isDirectory()));
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testCreateDirWithSamePathAsExistingFileFails() throws Exception {
        Path file = this.getPathPAf();
        Files.createDirectory(file, new FileAttribute[0]);
    }

    @Test
    public void testCreateDirSetsModifiedTimeOfParent() throws IOException, InterruptedException {
        Path tmp = this.emptyDir();
        FileTime created = Files.getLastModifiedTime(tmp, new LinkOption[0]);
        Thread.sleep(2000L);
        Files.createDirectory(tmp.resolve(this.nameStr[0]), new FileAttribute[0]);
        FileTime modified = Files.getLastModifiedTime(tmp, new LinkOption[0]);
        Assert.assertTrue((String)"created after modified", (created.compareTo(modified) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateDirSetsLastAccessTimeOfParent() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        Files.createDirectory(this.getPathPAB(), new FileAttribute[0]);
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testCreateDirSetsCreationTime() throws IOException, InterruptedException {
        Path dir = this.getPathPA();
        FileTime before = Files.getLastModifiedTime(dir.getParent(), new LinkOption[0]);
        Thread.sleep(1000L);
        Files.createDirectory(dir, new FileAttribute[0]);
        BasicFileAttributes atti = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]);
        Assert.assertThat((Object)atti.creationTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testKidsOfAbsoluteDirAreAbsolute() throws Exception {
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(this.nonEmptyDir());){
            for (Path kid : kids) {
                Assert.assertThat((Object)kid, PathAbsolute.absolute());
            }
        }
    }

    @Test
    public void testKidsOfRelativeDirAreRelative() throws Exception {
        Path abs = this.nonEmptyDir();
        Path rel = this.getDefaultPath().toAbsolutePath().relativize(abs);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(rel);){
            for (Path kid : kids) {
                Assert.assertThat((Object)kid, PathAbsolute.relative());
            }
        }
    }

    @Test
    public void testFilterOfRel() throws Exception {
        Path abs = this.nonEmptyDir();
        Path rel = this.getDefaultPath().toAbsolutePath().relativize(abs);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(rel);){
            for (Path kid : kids) {
                Assert.assertThat((Object)kid, PathAbsolute.relative());
            }
        }
    }

    @Test
    public void testKidsOfRelDirAreLikeTheResultOfResolve() throws Exception {
        Path abs = this.nonEmptyDir();
        Path rel = this.getDefaultPath().toAbsolutePath().relativize(abs);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(rel);){
            for (Path kid : kids) {
                Assert.assertThat((Object)kid, (Matcher)Is.is((Object)rel.resolve(kid.getFileName())));
            }
        }
    }

    @Test
    public void testReadDirStreamSetsLastAccessTime() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd().getParent();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
            }
        }
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testReadEmptyDirStreamSetsLastAccessTime() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
            }
        }
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testReadDirStreamDoesNotSetParentsLastAccessTime() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        FileTime before = Files.readAttributes(dir.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(dir);){
            for (Path kid : kids) {
            }
        }
        Assert.assertThat((Object)Files.readAttributes(dir.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)Is.is((Object)before));
    }

    @Test
    public void testGetIteratorOfClosedDirStream() throws Exception {
        Path file = this.getPathPABf();
        this.getPathPACf();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            kids.close();
            int count = 0;
            for (Path kid : kids) {
                ++count;
            }
            Assert.assertThat((Object)count, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(2)));
        }
    }

    @Test
    public void testCloseDirStreamInTheMiddleOfIteration() throws Exception {
        Path file = this.getPathPABf();
        this.getPathPACf();
        this.getPathPADf();
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            int count = 0;
            for (Path kid : kids) {
                if (++count != 1) continue;
                kids.close();
            }
            Assert.assertThat((Object)count, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(3)));
        }
    }

    @Test
    public void testReadBytesFromDirectoryThrows() throws IOException {
        try {
            Files.readAllBytes(this.getPathPAd());
        }
        catch (Exception e) {
            return;
        }
        Assert.fail((String)"reading directly from a dir should fail");
    }

    @Test(expected=NoSuchFileException.class)
    public void testNewDirectoryStreamFromNonExistingDirThrows() throws IOException {
        DirectoryStream<Path> kids = Files.newDirectoryStream(this.getPathA());
        Throwable throwable = null;
        if (kids != null) {
            if (throwable != null) {
                try {
                    kids.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                kids.close();
            }
        }
    }
}

