/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.matcher.FileTimeMatcher;
import de.pfabulist.lindwurm.niotest.matcher.IteratorMatcher;
import de.pfabulist.lindwurm.niotest.matcher.PathExists;
import de.pfabulist.lindwurm.niotest.tests.PathTest2DirIT;
import de.pfabulist.lindwurm.niotest.tests.TimeConversion;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest3FileIT
extends PathTest2DirIT {
    @Test(expected=NoSuchFileException.class)
    public void testReadCreateNonExistingFileThrows() throws IOException {
        Files.newByteChannel(this.getPathPA(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.CREATE_NEW, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE, StandardOpenOption.DSYNC, StandardOpenOption.CREATE}), new FileAttribute[0]);
    }

    @Test(expected=NoSuchFileException.class)
    public void testWriteFileWithoutExistingParentThrows() throws IOException {
        Files.write(this.getPathPAB(), CONTENT, StandardOpenOption.CREATE, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
    }

    @Test
    public void testWriteWithoutOptionsCreatesTheFile() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT, new OpenOption[0]);
        Assert.assertThat((Object)target, PathExists.exists());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChannelSetNegativePositionThrows() throws IOException {
        Path target = this.getPathPA();
        try (SeekableByteChannel channel = Files.newByteChannel(target, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            channel.position(-1L);
        }
    }

    @Test
    public void testChannelGetSize() throws IOException {
        Path target = this.getPathPA();
        try (SeekableByteChannel channel = Files.newByteChannel(target, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            Assert.assertThat((Object)channel.size(), (Matcher)Is.is((Object)Files.size(target)));
        }
    }

    @Test
    public void testWriteWithoutOptionsOverwritesExisting() throws IOException {
        Path target = this.getPathPAf();
        Files.write(target, CONTENT_OTHER, new OpenOption[0]);
        byte[] out = Files.readAllBytes(target);
        Assert.assertThat((Object)out, (Matcher)Is.is((Object)CONTENT_OTHER));
    }

    @Test
    public void testRWBytes() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT, standardOpen);
        byte[] out = Files.readAllBytes(target);
        Assert.assertThat((Object)out, (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testNewFileIsInDirStream() throws IOException {
        Path file = this.getPathPA();
        Files.write(file, CONTENT, standardOpen);
        try (DirectoryStream<Path> kids = Files.newDirectoryStream(file.getParent());){
            Assert.assertThat((Object)file, IteratorMatcher.isIn(kids));
        }
    }

    @Test
    public void testRWBytes20k() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT20k, standardOpen);
        byte[] out = Files.readAllBytes(target);
        Assert.assertThat((Object)out, (Matcher)Is.is((Object)CONTENT20k));
    }

    @Test
    public void testReadChunks() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT20k, standardOpen);
        byte[] out = new byte[2 * CONTENT20k.length];
        int sum = 0;
        try (SeekableByteChannel readChannel = Files.newByteChannel(target, StandardOpenOption.READ);){
            ByteBuffer bb;
            int count;
            while ((count = readChannel.read(bb = ByteBuffer.wrap(out, sum, 8009))) >= 0) {
                Assert.assertThat((Object)(sum += count), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(CONTENT20k.length + 200)));
            }
        }
        Assert.assertThat((Object)sum, (Matcher)Is.is((Object)CONTENT20k.length));
        Assert.assertThat((Object)Arrays.copyOfRange(out, 0, sum), (Matcher)Is.is((Object)CONTENT20k));
    }

    @Test
    public void testReadSmallChunks() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT50, standardOpen);
        byte[] out = new byte[2 * CONTENT50.length];
        int sum = 0;
        try (SeekableByteChannel readChannel = Files.newByteChannel(target, StandardOpenOption.READ);){
            ByteBuffer bb;
            int count;
            while ((count = readChannel.read(bb = ByteBuffer.wrap(out, sum, 12))) >= 0) {
                Assert.assertThat((Object)(sum += count), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(CONTENT50.length + 20)));
            }
        }
        Assert.assertThat((Object)sum, (Matcher)Is.is((Object)CONTENT50.length));
        Assert.assertThat((Object)Arrays.copyOfRange(out, 0, sum), (Matcher)Is.is((Object)CONTENT50));
    }

    @Test
    public void testWriteSmallChunks() throws Exception {
        Path target = this.getPathPA();
        Files.write(target, Arrays.copyOfRange(CONTENT, 0, 3), new OpenOption[0]);
        Files.write(target, Arrays.copyOfRange(CONTENT, 3, CONTENT.length), StandardOpenOption.APPEND);
        Assert.assertThat((Object)Files.readAllBytes(target), (Matcher)Is.is((Object)CONTENT));
    }

    @Test
    public void testClosedChannelIsClosed() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT, standardOpen);
        try (SeekableByteChannel read = Files.newByteChannel(target, new OpenOption[0]);){
            read.close();
            Assert.assertThat((Object)read.isOpen(), (Matcher)Is.is((Object)false));
        }
    }

    @Test(expected=ClosedChannelException.class)
    public void testReadFromClosedChannel() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT, standardOpen);
        try (SeekableByteChannel read = Files.newByteChannel(target, new OpenOption[0]);){
            read.close();
            read.read(ByteBuffer.allocate(30));
        }
    }

    @Test(expected=ClosedChannelException.class)
    public void testWriteFromClosedChannel() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT, standardOpen);
        try (SeekableByteChannel write = Files.newByteChannel(target, StandardOpenOption.WRITE);){
            write.close();
            write.write(ByteBuffer.allocate(30));
        }
    }

    @Test
    public void testSize() throws IOException {
        Path target = this.getPathPA();
        Files.write(target, CONTENT, standardOpen);
        Assert.assertThat((Object)Files.readAttributes(target, BasicFileAttributes.class, new LinkOption[0]).size(), (Matcher)Is.is((Object)CONTENT.length));
    }

    @Test
    public void testFileAttributesAreImmutable() throws Exception {
        Path file = this.getPathPA();
        Files.write(file, CONTENT, standardOpen);
        BasicFileAttributes atti = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        long oldSize = atti.size();
        Files.write(file, CONTENT_OTHER, StandardOpenOption.APPEND);
        Assert.assertThat((Object)atti.size(), (Matcher)Is.is((Object)oldSize));
    }

    @Test(expected=NoSuchFileException.class)
    public void testWriteNonExistent() throws IOException {
        Path notthere = this.getPathPA();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(notthere, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test
    public void testWriteNothingOverExistingFileDoesNotChangeIt() throws IOException {
        Path there = this.getPathPAf();
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.size(there), (Matcher)Is.is((Object)CONTENT.length));
    }

    @Test
    public void testWriteAndCreateNonExistent() throws IOException {
        Path notthere = this.getPathPA();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(notthere, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)notthere, PathExists.exists());
    }

    @Test
    public void testWriteAndCreateExistent() throws IOException {
        Path there = this.getPathPAf();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)there, PathExists.exists());
    }

    @Test
    public void testAppend() throws IOException {
        Path there = this.getPathPAf();
        Files.write(there, CONTENT, StandardOpenOption.APPEND);
        Assert.assertThat((Object)Files.size(there), (Matcher)Is.is((Object)((long)CONTENT.length * 2L)));
        byte[] out = Files.readAllBytes(there);
        Assert.assertThat((Object)Arrays.copyOfRange(out, 0, CONTENT.length), (Matcher)Is.is((Object)CONTENT));
        Assert.assertThat((Object)Arrays.copyOfRange(out, CONTENT.length, 2 * CONTENT.length), (Matcher)Is.is((Object)CONTENT));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAppendAndReadThrows() throws IOException {
        SeekableByteChannel ch = this.FS.provider().newByteChannel(this.getPathPAf(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.READ}), new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test
    public void testWriteAndCreateNewNonExistent() throws IOException {
        Path notthere = this.getPathPA();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(notthere, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)notthere, PathExists.exists());
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testWriteOnlyNew() throws IOException {
        Path there = this.getPathPAf();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void testWriteOnlyNewIfCreateIsThereToo() throws IOException {
        Path there = this.getPathPAf();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW, StandardOpenOption.CREATE});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
    }

    @Test
    public void testOverwriteTruncateExisting() throws IOException {
        Path there = this.getPathPAf();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)there, PathExists.exists());
        Assert.assertThat((Object)Files.size(there), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void testOverwriteTruncateExistingDoesNotChangeCreationTime() throws IOException {
        Path there = this.getPathPAf();
        FileTime created = Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).creationTime();
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).creationTime(), (Matcher)Is.is((Object)created));
    }

    @Test
    public void testOverwriteSetLastAccessTime() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path there = this.getPathPAf();
        FileTime before = Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.readAttributes(there, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testOverwriteDoesNotSetLastAccessTimeOfParent() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path there = this.getPathPAf();
        FileTime before = Files.readAttributes(there.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        Set options = Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING});
        SeekableByteChannel ch = this.FS.provider().newByteChannel(there, options, new FileAttribute[0]);
        Throwable throwable = null;
        if (ch != null) {
            if (throwable != null) {
                try {
                    ch.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ch.close();
            }
        }
        Assert.assertThat((Object)Files.readAttributes(there.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)Is.is((Object)before));
    }

    @Test
    public void testCreateFileSetsModifiedTimeOfParent() throws IOException, InterruptedException {
        Path file = this.getPathPA();
        FileTime created = Files.getLastModifiedTime(file.getParent(), new LinkOption[0]);
        Thread.sleep(2000L);
        Files.write(file, CONTENT, standardOpen);
        FileTime modified = Files.getLastModifiedTime(file.getParent(), new LinkOption[0]);
        Assert.assertThat((String)"created after modified", (Object)modified, (Matcher)OrderingComparison.greaterThan((Comparable)created));
    }

    @Test
    public void testCreateFileSetsLastAccessTime() throws IOException, InterruptedException {
        Path file = this.getPathPAf();
        BasicFileAttributes bfa = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        Assert.assertThat((Object)bfa.lastAccessTime(), FileTimeMatcher.isCloseTo(bfa.creationTime()));
    }

    @Test
    public void testCreateFileSetsLastAccessTimeOfParent() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path dir = this.getPathPAd();
        FileTime before = Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        Files.write(this.getPathPABf(), CONTENT, new OpenOption[0]);
        Assert.assertThat((Object)Files.readAttributes(dir, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testCreateFileSetModifiedTime() throws Exception {
        Path file = this.getPathPA();
        FileTime parentCreated = Files.getLastModifiedTime(file.getParent(), new LinkOption[0]);
        Thread.sleep(2000L);
        this.getPathPAf();
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), (Matcher)OrderingComparison.greaterThan((Comparable)parentCreated));
    }

    @Test
    public void testGetLastModifiedOnlyChangedByModification() throws Exception {
        Path file = this.getPathPAf();
        FileTime modified = Files.getLastModifiedTime(file, new LinkOption[0]);
        Thread.sleep(2000L);
        FileTime notmodified = Files.getLastModifiedTime(file, new LinkOption[0]);
        Assert.assertThat((Object)notmodified, (Matcher)Is.is((Object)modified));
    }

    @Test
    public void testModifiedDateIsCloseToCurrentTime() throws Exception {
        Path file = this.getPathPAf();
        FileTime before = TimeConversion.toFileTime(new Date());
        Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), FileTimeMatcher.isCloseTo(before));
    }

    @Test
    public void testReadFileSetsLastAccessTime() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path file = this.getPathPAf();
        FileTime before = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        Files.readAllBytes(file);
        Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)OrderingComparison.greaterThan((Comparable)before));
    }

    @Test
    public void testReadFileDoesNotSetParentsLastAccessTime() throws Exception {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path file = this.getPathPAf();
        FileTime before = Files.readAttributes(file.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
        Thread.sleep(2000L);
        Files.readAllBytes(file);
        Assert.assertThat((Object)Files.readAttributes(file.getParent(), BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)Is.is((Object)before));
    }

    @Test
    public void testReadFromExausted() throws IOException {
        Path file = this.getPathPABf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
            channel.read(ByteBuffer.allocate(CONTENT.length * 2));
            ByteBuffer bb = ByteBuffer.allocate(CONTENT.length * 2);
            int ret = channel.read(bb);
            Assert.assertThat((Object)ret, (Matcher)Is.is((Object)-1));
            Assert.assertThat((Object)bb.position(), (Matcher)Is.is((Object)0));
        }
    }

    @Test
    public void testChannelSetPositionSetsPosition() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel out = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);){
            out.position(1L);
            Assert.assertThat((Object)out.position(), (Matcher)Is.is((Object)1L));
        }
    }

    @Test
    public void testRandomWrite() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel out = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);){
            out.position(1L);
            out.write(ByteBuffer.wrap("waa".getBytes("UTF-8")));
        }
        Assert.assertThat((Object)new String(Files.readAllBytes(file), "UTF-8"), (Matcher)Is.is((Object)"hwaahere"));
    }

    @Test
    public void testWriteBeyondFileSize() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel out = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.WRITE), new FileAttribute[0]);){
            out.position(100L);
            out.write(ByteBuffer.wrap("ha".getBytes("UTF-8")));
        }
        Assert.assertThat((Object)Files.size(file), (Matcher)Is.is((Object)102L));
    }

    @Test
    public void testRandomRead() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
            channel.position(1L);
            ByteBuffer buffer = ByteBuffer.allocate(2);
            channel.read(buffer);
            Assert.assertThat((Object)buffer.array(), (Matcher)Is.is((Object)Arrays.copyOfRange(CONTENT, 1, 3)));
        }
    }

    @Test
    public void testRandomReadPosition() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);){
            channel.position(1L);
            ByteBuffer buffer = ByteBuffer.allocate(2);
            channel.read(buffer);
            Assert.assertThat((Object)channel.position(), (Matcher)Is.is((Object)3L));
        }
    }

    @Test
    public void testReadAndWrite() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel inout = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.READ}), new FileAttribute[0]);){
            inout.position(1L);
            inout.write(ByteBuffer.wrap("waa".getBytes("UTF-8")));
            Assert.assertThat((Object)new String(Files.readAllBytes(file), "UTF-8"), (Matcher)Is.is((Object)"hwaahere"));
            inout.position(2L);
            ByteBuffer buffer = ByteBuffer.allocate(2);
            inout.read(buffer);
            Assert.assertThat((Object)buffer.array()[0], (Matcher)Is.is((Object)"a".getBytes()[0]));
        }
    }

    @Test(expected=NonReadableChannelException.class)
    public void testReadFromWriteOnlyChannelThrows() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.read(ByteBuffer.allocate(2));
        }
    }

    @Test(expected=NonWritableChannelException.class)
    public void testWriteToReadOnlyChannelThrows() throws IOException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            channel.write(ByteBuffer.allocate(2));
        }
    }

    @Test
    public void testTruncate() throws Exception {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
        Assert.assertThat((Object)Files.size(file), (Matcher)Is.is((Object)2L));
    }

    @Test(expected=NonWritableChannelException.class)
    public void testTruncateOnReadChannelThrows() throws Exception {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            channel.truncate(2L);
        }
    }

    @Test(expected=ClosedChannelException.class)
    public void testTruncateOnClosedChannelThrows() throws Exception {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.close();
            channel.truncate(2L);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTruncateToNegativeSizeThrows() throws Exception {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            channel.truncate(-7L);
        }
    }

    @Test(expected=FileSystemException.class)
    public void testWriteChannelOfDir() throws IOException {
        SeekableByteChannel channel = this.FS.provider().newByteChannel(this.getPathPAd(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);
        Throwable throwable = null;
        if (channel != null) {
            if (throwable != null) {
                try {
                    channel.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                channel.close();
            }
        }
    }

    @Test
    public void testEveryChannelWriteUpdatesLastModifiedTime() throws IOException, InterruptedException {
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.WRITE}), new FileAttribute[0]);){
            for (int i = 0; i < 3; ++i) {
                FileTime before = FileTime.fromMillis(System.currentTimeMillis());
                Thread.sleep(2000L);
                ByteBuffer bb = ByteBuffer.allocate(20);
                bb.array()[5] = (byte)i;
                channel.write(bb);
                Assert.assertThat((Object)Files.getLastModifiedTime(file, new LinkOption[0]), (Matcher)Matchers.greaterThan((Comparable)before));
            }
        }
    }

    @Test
    public void testEveryChannelReadUpdatesLastAccessTime() throws IOException, InterruptedException {
        Assume.assumeThat((Object)this.capabilities.supportsLastAccessTime(), (Matcher)Is.is((Object)true));
        Path file = this.getPathPAf();
        try (SeekableByteChannel channel = this.FS.provider().newByteChannel(file, Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);){
            for (int i = 0; i < 3; ++i) {
                FileTime before = FileTime.fromMillis(System.currentTimeMillis());
                Thread.sleep(2000L);
                ByteBuffer bb = ByteBuffer.allocate(3);
                channel.read(bb);
                Assert.assertThat((Object)Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime(), (Matcher)Matchers.greaterThan((Comparable)before));
            }
        }
    }
}

