/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.PathTest4CopyIT;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public abstract class PathTest5URIIT
extends PathTest4CopyIT {
    @Test
    public void testFileSystemOfAPathIsTheConstructingOne() {
        Assert.assertEquals((Object)this.FS, (Object)this.FS.getPath("", new String[0]).getFileSystem());
    }

    @Test
    public void testSeparatorIsNotEmpty() {
        Assert.assertThat((Object)this.FS.getSeparator().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void testSchemeIsNotEmpty() {
        Assert.assertThat((Object)this.FS.provider().getScheme().isEmpty(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProviderGetFileSystemWithWrongSchemeFails() {
        this.FS.provider().getFileSystem(URI.create(this.FS.provider().getScheme() + "N:"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongUriAtProviderNewFails() throws IOException {
        this.FS.provider().newFileSystem(URI.create(this.FS.provider().getScheme() + "N:"), Collections.EMPTY_MAP);
    }

    @Test
    public void testToUriOfRelativePathIsTheUriOfTheAbsolute() throws Exception {
        Assert.assertEquals((Object)this.getDefaultPath().toAbsolutePath().toUri(), (Object)this.getDefaultPath().toUri());
    }

    @Test
    public void testGetExistingFileSystem() throws IOException {
        FileSystem fs = this.FS.provider().getFileSystem(this.capabilities.toURI().apply(this.FS));
        Assert.assertThat((Object)fs, (Matcher)Is.is((Object)this.FS));
    }

    @Test(expected=FileSystemAlreadyExistsException.class)
    public void testNewFileSystemOfExistingThrows() throws IOException {
        this.FS.provider().newFileSystem(this.capabilities.toURI().apply(this.FS), Collections.EMPTY_MAP);
    }

    @Test
    public void testPathToUriAndBackIsSame() {
        Path path = this.getPathRAB();
        URI uri = path.toUri();
        Assert.assertThat((Object)uri, (Matcher)IsNull.notNullValue());
        Path back = Paths.get(uri);
        Assert.assertThat((Object)back, (Matcher)Is.is((Object)path));
    }

    @Test
    public void testPathWithWitespaceToUri() {
        Path path = this.getPathRAB().resolve("z z");
        URI uri = path.toUri();
        Assert.assertThat((Object)uri, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testPathWithWitespaceToUriAndBack() {
        Path path = this.getPathRAB().resolve("z z");
        URI uri = path.toUri();
        Assert.assertThat((Object)uri, (Matcher)IsNull.notNullValue());
        Path back = Paths.get(uri);
        Assert.assertThat((Object)back, (Matcher)Is.is((Object)path));
    }
}

