/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.collection.Sets;
import de.pfabulist.lindwurm.niotest.tests.ClosedFSVars;
import de.pfabulist.lindwurm.niotest.tests.PathTest6AttributesIT;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest7ClosedIT
extends PathTest6AttributesIT {
    private ClosedFSVars closed;

    @Test
    public void testAAA7ClosableHasClosedFS() throws Exception {
        Assert.assertThat((Object)this.getClosedFS(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testClosedFSisClosed() throws Exception {
        Assert.assertThat((Object)this.getClosedFS().isOpen(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testStdFSisOpen() throws Exception {
        Assume.assumeThat((Object)this.capabilities.isClosable(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCantRead() throws Exception {
        Files.readAllBytes(this.getClosedAf());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCantReadDir() throws Exception {
        Files.newDirectoryStream(this.getClosedBd());
    }

    @Test(expected=ClosedChannelException.class)
    public void testClosedFSCantUseReadChannelPosition() throws Exception {
        this.getClosedReadChannel().position();
    }

    @Test(expected=ClosedChannelException.class)
    public void testClosedFSCantUseReadChannelRead() throws Exception {
        this.getClosedReadChannel().read(ByteBuffer.allocate(2));
    }

    @Test(expected=ClosedChannelException.class)
    public void testClosedFSCantUseReadChannelSize() throws Exception {
        this.getClosedReadChannel().size();
    }

    @Test(expected=FileSystemNotFoundException.class)
    public void testCantGetClosedFSViaURI() throws Exception {
        this.getClosedFSProvider().getFileSystem(this.getClosedURI());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSnewByteChannel() throws Exception {
        this.getClosedFS();
        this.FS.provider().newByteChannel(this.getClosedAf(), Sets.asSet((Object[])new StandardOpenOption[]{StandardOpenOption.READ}), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSGetBasicFileAttributeViewProvider() throws IOException {
        this.getClosedFS();
        this.FS.provider().getFileAttributeView(this.getClosedAf(), BasicFileAttributeView.class, new LinkOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCreateDirectoryOtherProvider() throws IOException {
        this.getClosedFSProvider().createDirectory(this.getClosedAf(), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSNewFileChannel() throws IOException {
        this.getClosedFSProvider().newFileChannel(this.getClosedAf(), Collections.emptySet(), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCheckAccess() throws IOException {
        this.getClosedFS();
        this.FS.provider().checkAccess(this.getClosedAf(), new AccessMode[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testCopyFromClosedFS() throws IOException {
        this.getClosedFSProvider().copy(this.getClosedAf(), this.getPathPB(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testCopyToClosedFS() throws IOException {
        this.getClosedFSProvider().copy(this.getPathPB(), this.getClosedAf(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testMoveToClosedFS() throws IOException {
        this.getClosedFSProvider().move(this.getPathPABf(), this.getClosedAf(), new CopyOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSCreateHardLink() throws IOException {
        this.getClosedFSProvider().createLink(this.getClosedAf(), this.getClosedAf());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCreateSymbolicLinkOtherProvider() throws IOException {
        Assume.assumeThat((Object)this.capabilities.hasSymbolicLinks(), (Matcher)Is.is((Object)true));
        Assume.assumeThat((Object)this.capabilities.isClosable(), (Matcher)CoreMatchers.is((Object)true));
        this.getClosedFSProvider().createSymbolicLink(this.getClosedAf(), this.getClosedAf(), new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSDelete() throws IOException {
        this.getClosedFSProvider().delete(this.getClosedAf());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSGetFileStore() throws IOException {
        this.getClosedFSProvider().getFileStore(this.getClosedAf());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSIsHidden() throws IOException {
        this.getClosedFSProvider().isHidden(this.getClosedAf());
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSNewAsynchronousFileChannel() throws IOException {
        Assume.assumeThat((Object)this.capabilities.hasAsynchronousFileChannels(), (Matcher)Is.is((Object)true));
        this.getClosedFSProvider().newAsynchronousFileChannel(this.getClosedAf(), Collections.emptySet(), null, new FileAttribute[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSNewInputStream() throws IOException {
        this.getClosedFSProvider().newOutputStream(this.getClosedAf(), new OpenOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSNewOutputStream() throws IOException {
        this.getClosedFSProvider().newOutputStream(this.getClosedAf(), new OpenOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSReadAttributes() throws IOException {
        this.getClosedFSProvider().readAttributes(this.getClosedAf(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test(expected=ClosedFileSystemException.class)
    public void testClosedFSReadAttributesString() throws IOException {
        this.getClosedFSProvider().readAttributes(this.getClosedAf(), "*", new LinkOption[0]);
    }

    public void setClosablePlay(ClosedFSVars vars) {
        this.closed = vars;
    }

    public FileSystem getClosedFS() throws IOException {
        if (this.closed.fs == null) {
            this.closed.fs = this.closed.play.getFileSystem();
        }
        if (!this.closed.fs.isOpen()) {
            return this.closed.fs;
        }
        this.closed.provider = this.closed.fs.provider();
        this.closed.pathAf = this.closed.play.resolve(this.nameStr[0]);
        this.closed.pathBd = this.closed.play.resolve(this.nameStr[1]);
        Files.createDirectories(this.closed.play, new FileAttribute[0]);
        Files.write(this.closed.pathAf, CONTENT, standardOpen);
        this.closed.provider.createDirectory(this.closed.pathBd, new FileAttribute[0]);
        Path closedCf = this.closed.play.resolve(this.nameStr[2]);
        Files.write(closedCf, CONTENT, standardOpen);
        this.closed.readChannel = Files.newByteChannel(closedCf, StandardOpenOption.READ);
        this.closed.uri = this.closed.play.getRoot().toUri();
        this.closed.dirStream = Files.newDirectoryStream(this.closed.play);
        if (this.capabilities.supportsWatchService()) {
            this.closed.watchService = this.closed.fs.newWatchService();
        }
        this.closed.fs.close();
        return this.closed.fs;
    }

    public FileSystemProvider getClosedFSProvider() throws IOException {
        this.getClosedFS();
        return this.FS.provider();
    }

    public Path getClosedAf() throws IOException {
        this.getClosedFS();
        return this.closed.pathAf;
    }

    public Path getClosedBd() throws IOException {
        this.getClosedFS();
        return this.closed.pathBd;
    }

    public URI getClosedURI() throws IOException {
        this.getClosedFS();
        return this.closed.uri;
    }

    public SeekableByteChannel getClosedReadChannel() throws IOException {
        this.getClosedAf();
        return this.closed.readChannel;
    }

    public WatchService getClosedFSWatchService() throws IOException {
        this.getClosedFS();
        return this.closed.watchService;
    }
}

