/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.lindwurm.niotest.tests.PathTest7ClosedIT;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantLock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public abstract class PathTest8ThreadSafeIT
extends PathTest7ClosedIT {
    private static final ReentrantLock lock = new ReentrantLock();

    @Test
    public void testThreadedDirCount() throws IOException, ExecutionException, InterruptedException {
        this.getPathPAf();
        this.getPathPBf();
        try {
            lock.lock();
            ExecutorService executor = Executors.newFixedThreadPool(3);
            Future<Long> future = executor.submit(new KidsCounter(this.getPathP()));
            executor.shutdown();
            Thread.sleep(1000L);
            this.getPathPCf();
            lock.unlock();
            Assert.assertThat((Object)future.get(), (Matcher)CoreMatchers.is((Object)2L));
        }
        finally {
            if (lock.isHeldByCurrentThread()) {
                lock.unlock();
            }
        }
    }

    public static class KidsCounter
    implements Callable<Long> {
        private final Path parent;

        public KidsCounter(Path parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() throws Exception {
            long sum = 0L;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.parent);){
                for (Path kid : stream) {
                    if (++sum <= 0L) continue;
                    try {
                        lock.lock();
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            return sum;
        }
    }
}

