/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.lindwurm.niotest.tests;

import de.pfabulist.kleinod.paths.PathUtils;
import de.pfabulist.lindwurm.niotest.tests.PathTest8ThreadSafeIT;
import java.io.IOException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assume;
import org.junit.Test;

public abstract class PathTest9WrongProviderIT
extends PathTest8ThreadSafeIT {
    @Test(expected=ProviderMismatchException.class)
    public void testNewByteChannelOtherProvider() throws IOException {
        this.FS.provider().newByteChannel(this.getOther(), Collections.emptySet(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testGetBasicFileAttributeViewProvider() throws IOException {
        this.FS.provider().getFileAttributeView(this.getOther(), BasicFileAttributeView.class, new LinkOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCreateDirectoryOtherProvider() throws IOException {
        this.FS.provider().createDirectory(this.getOther(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewFileChannelOtherProvider() throws IOException {
        Assume.assumeThat((Object)this.capabilities.hasFileChannels(), (Matcher)Is.is((Object)true));
        this.FS.provider().newFileChannel(this.getOther(), Collections.emptySet(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCheckAccessOtherProvider() throws IOException {
        this.FS.provider().checkAccess(this.getOther(), new AccessMode[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCopyOtherProviderFrom() throws IOException {
        this.FS.provider().copy(this.getOther(), this.getPathPABf(), new CopyOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testCopyOtherProviderTo() throws IOException {
        this.FS.provider().copy(this.getPathPABf(), this.getOther(), new CopyOption[0]);
    }

    @Test
    public void testCopyOtherProviderWithFiles() throws IOException {
        Path defaultTarget = PathUtils.getTmpDir((String)"foo").resolve("duh");
        Files.createDirectories(defaultTarget.getParent(), new FileAttribute[0]);
        Files.copy(this.getPathPABf(), defaultTarget, new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(defaultTarget), (Matcher)Is.is((Object)CONTENT));
        Files.deleteIfExists(defaultTarget);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testMoveOtherProviderFrom() throws IOException {
        this.FS.provider().move(this.getOther(), this.getPathPB(), new CopyOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testMoveOtherProviderTo() throws IOException {
        this.FS.provider().move(this.getPathPABf(), this.getOther(), new CopyOption[0]);
    }

    @Test
    public void testMoveOtherProviderWithFiles() throws IOException {
        Path defaultTarget = PathUtils.getTmpDir((String)"foo").resolve("duh");
        Files.createDirectories(defaultTarget.getParent(), new FileAttribute[0]);
        Files.move(this.getPathPABf(), defaultTarget, new CopyOption[0]);
        MatcherAssert.assertThat((Object)Files.readAllBytes(defaultTarget), (Matcher)Is.is((Object)CONTENT));
        Files.deleteIfExists(defaultTarget);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testHardLinkToDifferentProvider() throws IOException {
        this.FS.provider().createLink(this.getOther(), this.getOther());
    }

    @Override
    @Test(expected=ProviderMismatchException.class)
    public void testCreateSymbolicLinkOtherProvider() throws IOException {
        Assume.assumeThat((Object)this.capabilities.hasSymbolicLinks(), (Matcher)Is.is((Object)true));
        this.FS.provider().createSymbolicLink(this.getOther(), this.getOther(), new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testDeleteOtherProvider() throws IOException {
        this.FS.provider().delete(this.getOther());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testDeleteIfExistsOtherProvider() throws IOException {
        this.FS.provider().deleteIfExists(this.getOther());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testGetFileStoreOtherProvider() throws IOException {
        this.FS.provider().getFileStore(this.getOther());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetPathOtherURI() throws IOException {
        this.FS.provider().getPath(this.getOther().toUri());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetFileSystemOtherURI() throws IOException {
        this.FS.provider().getFileSystem(this.capabilities.toURI().apply(this.getOther().getFileSystem()));
    }

    @Test(expected=ProviderMismatchException.class)
    public void testIsHiddenOtherProvider() throws IOException {
        this.FS.provider().isHidden(this.getOther());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewAsynchronousFileChannelOtherProvider() throws IOException {
        Assume.assumeThat((Object)this.capabilities.hasAsynchronousFileChannels(), (Matcher)Is.is((Object)true));
        this.FS.provider().newAsynchronousFileChannel(this.getOther(), Collections.emptySet(), null, new FileAttribute[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewOutputStreamOtherProvider() throws IOException {
        this.FS.provider().newOutputStream(this.getOther(), new OpenOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testNewDirectoryStreamOtherProvider() throws IOException {
        this.FS.provider().newDirectoryStream(this.getOther(), null);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testReadAttributesOtherProvider() throws IOException {
        this.FS.provider().readAttributes(this.getOther(), BasicFileAttributes.class, new LinkOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testReadAttributesStringOtherProvider() throws IOException {
        this.FS.provider().readAttributes(this.getOther(), "*", new LinkOption[0]);
    }

    @Test(expected=ProviderMismatchException.class)
    public void testReadSymbolicLinkOtherProvider() throws IOException {
        Assume.assumeThat((Object)this.capabilities.hasSymbolicLinks(), (Matcher)Is.is((Object)true));
        this.FS.provider().readSymbolicLink(this.getOther());
    }

    @Test(expected=ProviderMismatchException.class)
    public void testResolveWithPathFromOtherProvider() throws IOException {
        MatcherAssert.assertThat((Object)this.getPathB().resolve(this.getOther()), (Matcher)Is.is((Object)this.getOther()));
    }
}

