package de.pfabulist.roast.collection;

import de.pfabulist.roast.NonnullCheck;

import java.util.List;
import java.util.stream.Stream;

import static de.pfabulist.roast.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class ArrayList_<T> implements List_<T>{

    private final List<T> inner;

    public ArrayList_( List<T> inner ) {
        this.inner = inner;
        stream_().forEach( e -> n_( e, () -> new IllegalStateException( "no null as element in List_ allowed" )) );
    }

    @Override
    public List<T> _r() {
        return inner;
    }

    public Stream<T> stream_() {
        return n_(inner.stream());
    }
}
