package de.pfabulist.roast.collection;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

import javax.annotation.Nullable;
import java.util.concurrent.atomic.AtomicReference;

import static de.pfabulist.roast.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

/**
 * enhace AtomicReference with equals and hashCode implementation
 *
 * @param <T>
 */
@SuppressWarnings( "PMD.UseUtilityClass" ) // todo PMD bug ? equals
public class AtomicReference_of<T> implements AtomicReference_<T>  {

    private static final long serialVersionUID = 1L;
    private final AtomicReference<T> inner;

    public AtomicReference_of( AtomicReference<T> t ) {
        this.inner = t;
    }

    public AtomicReference_of( T t ) {
        this( new AtomicReference<>( t ) );
    }

    @Override
    @SuppressFBWarnings( "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION" )
    @SuppressWarnings( "PMD.ConfusingTernary" ) // generated equals, i.e. not for reading
    public boolean equals( @Nullable Object o ) {
        synchronized( this ) {

            if( this == o ) {
                return true;
            }
            if( o == null || getClass() != o.getClass() ) {
                return false;
            }

            return get_().equals( ( (AtomicReference_) o ).get_() );
        }
    }

    @Override
    @SuppressWarnings( "PMD.ConfusingTernary" ) // generated, i.e. not for reading
    public int hashCode() {
        synchronized( this ) {
            return get_().hashCode();
        }
    }

    public T get_() {
        // member r_ superclass may be null but not r_ Ref
        return n_(inner.get());
    }

    @Override
    public void set_( T t ) {
        inner.set( t );
    }

//    public static <T> Ref<T> valueOf( T t ) {
//        return new Ref<>( t );
//    }

    @Override
    public AtomicReference<T> _r() {
        return inner;
    }
}
