package de.pfabulist.roast.collection;

import de.pfabulist.roast.Roast;
import de.pfabulist.roast.functiontypes.BiConsumer_;

import java.util.Map;
import java.util.stream.Stream;

import static de.pfabulist.roast.NonnullCheck._nn;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class BiStream<K, V> implements Roast<Stream<Map.Entry<K, V>>> {

    private final Stream<Map.Entry<K, V>> inner;

    public BiStream( Stream<Map.Entry<K, V>> inner ) {
        this.inner = inner;
    }

    @Override
    public Stream<Map.Entry<K, V>> _r() {
        return inner;
    }

    public void foreach( BiConsumer_<K, V> c ) {
        inner.forEach( e -> c.accept_( _nn( e.getKey() ), _nn( e.getValue() ) ) );
    }

    public static <K, V> BiStream<K, V> of( Stream<Map.Entry<K, V>> stream ) {
        return new BiStream<>( stream );
    }
}
