package de.pfabulist.roast.collection;

import de.pfabulist.roast.Roast;
import de.pfabulist.roast.functiontypes.Function_;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

import static de.pfabulist.roast.unchecked.Unchecked.u;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public interface Map_<K,V> extends Roast<Map> {

    static <A, B> Map_<A, B> r_( Map<A, B> map ) {
        if( map instanceof Map_ ) {
            return (Map_<A,B>) map;
        }

        return new Map_of<>( map );
    }

    static <A, B> Map_<A, B> std() {
        return new Map_of<>( new ConcurrentHashMap<A, B>() );
    }

    Optional<V> get_o( K key );

    default V get_ot( K key, Exception e ) {
        return get_o( key ).orElseThrow( () -> u( e ) );
    }

    default V get_ot( K key ) {
        return get_ot( key, new IllegalArgumentException( "no such key " + key ) );
    }

    Set<K> keySet_();

    boolean containsKey_( K key );

    boolean containsValue_( V value );

    Optional<V> put_o( K key, V value );

    Collection<V> values_();

    Optional<V> remove_o( K id );

    V computeIfAbsent_( K key, Function_<? super K, ? extends V> mappingFunction);

    void forEach_( BiConsumer<? super K, ? super V> action );

    int size_();
}