 package de.pfabulist.roast.collection;

import de.pfabulist.roast.functiontypes.Function_;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;

import static de.pfabulist.roast.NonnullCheck.n_;

 /**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Map_of<K,V> implements Map_<K,V>{

    private final Map<K,V> inner;

    public Map_of( Map<K, V> inner ) {
        this.inner = inner;
    }

    @Override
    public Map<K,V> _r() {
        return inner;
    }

    @Override
    public Optional<V> get_o( K key ) {
        return Optional.ofNullable( inner.get( key ) );
    }

//    @Override
//    public int size_() {
//        return inner.size_();
//    }
//
//    @Override
//    public boolean isEmpty() {
//        return inner.isEmpty();
//    }
//
//    @Override
//    public boolean containsKey( Object key ) {
//        return inner.containsKey( key );
//    }
//
//    @Override
//    public boolean containsValue( Object value ) {
//        return false;
//    }
//
//    @Override
//    public @Nullable V get_( @Nullable Object key ) {
//        return inner.get_( key );
//    }
//
//    @Override
//    public @Nullable V put( @Nullable K key, @Nullable V value ) {
//        return inner.put( key, value );
//    }
//
//    @Override
//    public @Nullable V remove( @Nullable Object key ) {
//        return inner.remove( key );
//    }
//
//    @Override
//    public void putAll( Map<? extends K, ? extends V> m ) {
//
//    }
//
//    @Override
//    public void clear() {
//
//    }
//
    @Override
    public Set<K> keySet_() {
        return inner.keySet();
    }

    @Override
    public boolean containsKey_( K key ) {
        return inner.containsKey( key );
    }

    @Override
    public boolean containsValue_( V value ) {
        return inner.containsValue( value );
    }

    @Override
    public Optional<V> put_o( K key, V value ) {
        return Optional.ofNullable( inner.put( key, value ));
    }

    @Override
    public Collection<V> values_() {
        return inner.values();
    }

    @Override
    public Optional<V> remove_o( K id ) {
        return Optional.ofNullable( inner.remove( id ));
    }

    @Override
    public V computeIfAbsent_( K key, Function_<? super K, ? extends V> mappingFunction) {
        return n_( inner.computeIfAbsent( key, mappingFunction._r() ));
    }

     @Override
     public void forEach_( BiConsumer<? super K, ? super V> action ) {
         inner.forEach( action );
     }

     @Override
     public int size_() {
         return inner.size();
     }
//
//    @Override
//    public @Nullable Set<Entry<K, V>> entrySet() {
//        return inner.entrySet();
//    }
//
//    @Override
//    public @Nullable V putIfAbsent( @Nullable K key, @Nullable V value ) {
//        return inner.putIfAbsent( key, value );
//    }
//
//    @Override
//    public boolean remove( @Nullable Object key, @Nullable Object value ) {
//        return inner.remove( key, value );
//    }
//
//    @Override
//    public boolean replace( @Nullable K key, @Nullable V oldValue, @Nullable V newValue ) {
//        return inner.replace( key, oldValue, newValue );
//    }
//
//    @Override
//    public @Nullable V replace( @Nullable K key, @Nullable V value ) {
//        return inner.replace( key, value );
//    }
}
