//package de.pfabulist.roast.collection;
//
//import de.pfabulist.roast.Roast;
//
//import javax.annotation.Nullable;
//import java.util.HashMap;
//import java.util.Map;
//import java.util.Optional;
//import java.util.Set;
//import java.util.concurrent.ConcurrentHashMap;
//import java.util.stream.Stream;
//
///**
// * Copyright (c) 2006 - 2016, Stephan Pfab
// * SPDX-License-Identifier: BSD-2-Clause
// */
//
//public class Mapp<K, V> implements Roast<Map<K, V>> {
//
//    private final Map<K, V> inner;
//
//    public Mapp( Map<K, V> map ) {
//        inner = map;
//
//    }
//
//    public Mapp() {
//        inner = new ConcurrentHashMap<>();
//    }
//
//    public static <A, B> Mapp<A, B> r_( Map<A, B> map ) {
//        return new Mapp<>( map );
//    }
//
//    public static <A, B> Mapp<A, B> r_( A a, B b ) {
//        Map<A, B> ret = new ConcurrentHashMap<>();
//        ret.put( a, b );
//
//        return Mapp.r_( ret );
//    }
//
//    public static <A, B> Mapp<A, B> r_( A a1, B b1, A a2, B b2 ) {
//        Map<A, B> ret = new HashMap<>();
//        ret.put( a1, b1 );
//        ret.put( a2, b2 );
//
//        return Mapp.r_( ret );
//    }
//
//    @Override
//    public Map<K, V> _r() {
//        return inner;
//    }
//
//    public Optional<V> get_( K key ) {
//        return Optional.ofNullable( inner.get_( key ) );
//    }
//
//    public Optional<V> put( K key, V val ) {
//        return Optional.ofNullable( inner.put( key, val ));
//    }
//
//    public Optional<V> putIfAbsent( K key, V val ) {
//        return Optional.ofNullable( inner.putIfAbsent( key, val ));
//    }
//
//    public V getOrThrow( K key ) {
//        return Optional.ofNullable( inner.get_( key ) ).orElseThrow( () -> new IllegalStateException( "no such key" ) );
//    }
//
//    public Set<K> keySet() {
//        return inner.keySet();
//    }
//
//    public boolean containsKey( K key ) {
//        return inner.containsKey( key );
//    }
//
//    public Stream<Map.Entry<K, V>> stream() {
//        return inner.entrySet().stream();
//    }
//
//    public BiStream<K, V> biStream() {
//        return BiStream.r_( inner.entrySet().stream());
//    }
//
//    @Override
//    public boolean equals( @Nullable Object o ) {
//        if( this == o ) return true;
//        if( o == null || getClass() != o.getClass() ) return false;
//
//        Mapp<?, ?> mapp = (Mapp<?, ?>) o;
//
//        return inner.equals( mapp.inner );
//
//    }
//
//    @Override
//    public int hashCode() {
//        return inner.hashCode();
//    }
//
//}
