//package de.pfabulist.roast.collection;
//
//import javax.annotation.Nullable;
//import java.util.Collection;
//import java.util.Map;
//import java.util.Optional;
//import java.util.Set;
//import java.util.concurrent.ConcurrentHashMap;
//import java.util.concurrent.ConcurrentMap;
//
//import static de.pfabulist.roast.NonnullCheck._nn;
//
///**
// * Copyright (c) 2006 - 2016, Stephan Pfab
// * SPDX-License-Identifier: BSD-2-Clause
// */
//
//public class RoastMap<K, V> implements ConcurrentMap<K, V> {
//
//    private final ConcurrentHashMap<K, V> inner;
//
//    public RoastMap( ConcurrentHashMap<K, V> inner ) {
//        this.inner = inner;
//    }
//
//    @Override
//    public int size() {
//        return inner.size();
//    }
//
//    @Override
//    public boolean isEmpty() {
//        return inner.isEmpty();
//    }
//
//    @Override
//    public boolean containsKey( @Nullable Object key ) {
//        return inner.containsKey( key );
//    }
//
//    public boolean containsKey_( K key ) {
//        return inner.containsKey( key );
//    }
//
//    @Override
//    public boolean containsValue( @Nullable Object value ) {
//        return inner.containsValue( _nn( value ) );
//    }
//
//    public boolean containsValue_( V value ) {
//        return inner.containsValue( value );
//    }
//
//    @Override
//    public @Nullable V get( @Nullable Object key ) {
//        return inner.get( _nn( key ) );
//    }
//
//    public Optional<V> get_( K key ) {
//        return Optional.ofNullable( inner.get( key ) );
//    }
//
//    public V getOrThrow( K key ) {
//        return get_( key ).orElseThrow( () -> new IllegalArgumentException( "no mapping to key: " + key ) );
//    }
//
//    @Override
//    public @Nullable V put( @Nullable K key, @Nullable V value ) {
//        return inner.put( _nn( key ), _nn( value ) );
//    }
//
//    @Override
//    public @Nullable V remove( @Nullable Object key ) {
//        return inner.remove( _nn( key ) );
//    }
//
//    public Optional<V> remove_( K key ) {
//        return Optional.ofNullable( inner.remove( key ) );
//    }
//
//    @Override
//    public void putAll( @Nullable Map<? extends K, ? extends V> m ) {
//        inner.putAll( _nn( m ) );
//    }
//
//    @Override
//    public void clear() {
//        inner.clear();
//    }
//
//    @Override
//    public @Nullable Set<K> keySet() {
//        return inner.keySet();
//    }
//
//    public Set<K> keySet_() {
//        return inner.keySet();
//    }
//
//    @Override
//    public @Nullable Collection<V> values() {
//        return inner.values();
//    }
//
//    public Collection<V> values_() {
//        return inner.values();
//    }
//
//    @Override
//    public @Nullable Set<Entry<K, V>> entrySet() {
//        return inner.entrySet();
//    }
//
//    public Set<Entry<K, V>> entrySet_() {
//        return inner.entrySet();
//    }
//
//    @Override
//    public V putIfAbsent( K key, V value ) {
//        return null;
//    }
//
//    @Override
//    public boolean remove( Object key, Object value ) {
//        return false;
//    }
//
//    @Override
//    public boolean replace( K key, V oldValue, V newValue ) {
//        return false;
//    }
//
//    @Override
//    public V replace( K key, V value ) {
//        return null;
//    }
//}
