package de.pfabulist.roast.lang;

import java.io.InputStream;
import java.util.Optional;

import static de.pfabulist.roast.NonnullCheck.n_;

/**
 * Copyright (c) 2006 - 2017, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Class_of<T> implements Class_<T> {

    private final Class<T> inner;

    public Class_of( Class<T> inner ) {
        this.inner = inner;
    }

    @Override
    public Class<T> _r() {
        return inner;
    }

    @Override
    public Optional<InputStream> getResourceAsStream_o( String name ) {
        return Optional.ofNullable( inner.getResourceAsStream( name ) );
    }

    @Override
    public InputStream getResourceAsStream_ot( String name ) {
        return n_( inner.getResourceAsStream( name ),
                   () -> new NullPointerException( "no resource here " + name ) );
    }

}
