package de.pfabulist.roast.lang;

import de.pfabulist.roast.functiontypes.Supplier_;

import java.util.Optional;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public class Options_ {

    public static <T> Optional<T> fillIfEmpty( Optional<T> op, Supplier_<T> sup ) {
        if ( op.isPresent() ) {
            return op;
        }

        return Optional.of( sup.get_());
    }

    public static <T> T orElseThrow( Optional<T> op ) {
        return op.orElseThrow( () -> new IllegalArgumentException( "optional surprisingly empty" ) );
    }
}
